/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.util.clock.Clock;

public class DeclarativeSlotPoolServiceFactory
implements SlotPoolServiceFactory {
    private final Clock clock;
    private final Time idleSlotTimeout;
    private final Time rpcTimeout;

    public DeclarativeSlotPoolServiceFactory(Clock clock, Time idleSlotTimeout, Time rpcTimeout) {
        this.clock = clock;
        this.idleSlotTimeout = idleSlotTimeout;
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    @Nonnull
    public SlotPoolService createSlotPoolService(@Nonnull JobID jobId) {
        return new DeclarativeSlotPoolService(jobId, new DefaultDeclarativeSlotPoolFactory(), this.clock, this.idleSlotTimeout, this.rpcTimeout);
    }
}

