/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;

public class DirectoryKeyedStateHandle
implements KeyedStateHandle {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final DirectoryStateHandle directoryStateHandle;
    @Nonnull
    private final KeyGroupRange keyGroupRange;

    public DirectoryKeyedStateHandle(@Nonnull DirectoryStateHandle directoryStateHandle, @Nonnull KeyGroupRange keyGroupRange) {
        this.directoryStateHandle = directoryStateHandle;
        this.keyGroupRange = keyGroupRange;
    }

    @Nonnull
    public DirectoryStateHandle getDirectoryStateHandle() {
        return this.directoryStateHandle;
    }

    @Override
    @Nonnull
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public void discardState() throws Exception {
        this.directoryStateHandle.discardState();
    }

    @Override
    public long getStateSize() {
        return this.directoryStateHandle.getStateSize();
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange otherKeyGroupRange) {
        return this.keyGroupRange.getIntersection(otherKeyGroupRange).getNumberOfKeyGroups() > 0 ? this : null;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryKeyedStateHandle that = (DirectoryKeyedStateHandle)o;
        if (!this.getDirectoryStateHandle().equals(that.getDirectoryStateHandle())) {
            return false;
        }
        return this.getKeyGroupRange().equals(that.getKeyGroupRange());
    }

    public int hashCode() {
        int result = this.getDirectoryStateHandle().hashCode();
        result = 31 * result + this.getKeyGroupRange().hashCode();
        return result;
    }

    public String toString() {
        return "DirectoryKeyedStateHandle{directoryStateHandle=" + this.directoryStateHandle + ", keyGroupRange=" + this.keyGroupRange + '}';
    }
}

