/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.packer.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.streampark.flink.packer.pipeline.BuildResult;
import org.apache.streampark.flink.packer.pipeline.DockerImageBuildResponse;
import org.apache.streampark.flink.packer.pipeline.ShadedBuildResponse;
import org.apache.streampark.flink.packer.pipeline.SimpleBuildResponse;

public enum PipelineType {
    UNKNOWN(0, "", (Map<Integer, String>)ImmutableMap.of(), null),
    FLINK_NATIVE_K8S_SESSION(1, "flink native kubernetes session mode task building pipeline", (Map<Integer, String>)ImmutableMap.builder().put((Object)1, (Object)"Create building workspace").put((Object)2, (Object)"Build shaded flink app jar").build(), ShadedBuildResponse.class),
    FLINK_NATIVE_K8S_APPLICATION(2, "flink native kubernetes session mode task building pipeline", (Map<Integer, String>)ImmutableMap.builder().put((Object)1, (Object)"Create building workspace").put((Object)2, (Object)"Export kubernetes pod template").put((Object)3, (Object)"Build shaded flink app jar").put((Object)4, (Object)"Export flink app dockerfile").put((Object)5, (Object)"Pull flink app base docker image").put((Object)6, (Object)"Build flink app docker image").put((Object)7, (Object)"Push flink app docker image").build(), DockerImageBuildResponse.class),
    FLINK_STANDALONE(3, "flink standalone session mode task building pipeline", (Map<Integer, String>)ImmutableMap.builder().put((Object)1, (Object)"Create building workspace").put((Object)2, (Object)"Build shaded flink app jar").build(), ShadedBuildResponse.class),
    FLINK_YARN_APPLICATION(4, "flink yarn application mode task building pipeline", (Map<Integer, String>)ImmutableMap.builder().put((Object)1, (Object)"Prepare hadoop yarn environment and building workspace").put((Object)2, (Object)"Resolve maven dependencies").put((Object)3, (Object)"upload jar to yarn.provided.lib.dirs").build(), SimpleBuildResponse.class);

    private final Integer code;
    private final String desc;
    private final Map<Integer, String> steps;
    private final Class<? extends BuildResult> resultType;

    private PipelineType(Integer code, String desc, Map<Integer, String> steps, Class<? extends BuildResult> resultType) {
        this.code = code;
        this.desc = desc;
        this.steps = steps;
        this.resultType = resultType;
    }

    @JsonCreator
    public static PipelineType of(Integer code) {
        for (PipelineType type : PipelineType.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static PipelineType ofName(String name) {
        return PipelineType.valueOf(name);
    }

    @JsonValue
    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Map<Integer, String> getSteps() {
        return this.steps;
    }

    public Class<? extends BuildResult> getResultType() {
        return this.resultType;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }
}

