/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.OperatorTranslation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PlanGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(PlanGenerator.class);
    private final List<DataSink<?>> sinks;
    private final ExecutionConfig config;
    private final int defaultParallelism;
    private final List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cacheFile;
    private final String jobName;

    public PlanGenerator(List<DataSink<?>> sinks, ExecutionConfig config, int defaultParallelism, List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cacheFile, String jobName) {
        this.sinks = (List)Preconditions.checkNotNull(sinks);
        this.config = (ExecutionConfig)Preconditions.checkNotNull((Object)config);
        this.cacheFile = (List)Preconditions.checkNotNull(cacheFile);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.defaultParallelism = defaultParallelism;
    }

    public Plan generate() {
        Plan plan = this.createPlan();
        this.registerGenericTypeInfoIfConfigured(plan);
        this.registerCachedFiles(plan);
        this.logTypeRegistrationDetails();
        return plan;
    }

    private Plan createPlan() {
        OperatorTranslation translator = new OperatorTranslation();
        Plan plan = translator.translateToPlan(this.sinks, this.jobName);
        if (this.defaultParallelism > 0) {
            plan.setDefaultParallelism(this.defaultParallelism);
        }
        plan.setExecutionConfig(this.config);
        return plan;
    }

    private void registerGenericTypeInfoIfConfigured(Plan plan) {
        if (!this.config.isAutoTypeRegistrationDisabled()) {
            plan.accept(new Visitor<Operator<?>>(){
                private final Set<Class<?>> registeredTypes = new HashSet();
                private final Set<Operator<?>> visitedOperators = new HashSet();

                public boolean preVisit(Operator<?> visitable) {
                    if (!this.visitedOperators.add(visitable)) {
                        return false;
                    }
                    OperatorInformation opInfo = visitable.getOperatorInfo();
                    Serializers.recursivelyRegisterType((TypeInformation)opInfo.getOutputType(), (ExecutionConfig)PlanGenerator.this.config, this.registeredTypes);
                    return true;
                }

                public void postVisit(Operator<?> visitable) {
                }
            });
        }
    }

    private void registerCachedFiles(Plan plan) {
        try {
            this.registerCachedFilesWithPlan(plan);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while registering cached files: " + e.getMessage(), e);
        }
    }

    private void registerCachedFilesWithPlan(Plan p) throws IOException {
        for (Tuple2<String, DistributedCache.DistributedCacheEntry> entry : this.cacheFile) {
            p.registerCachedFile((String)entry.f0, (DistributedCache.DistributedCacheEntry)entry.f1);
        }
    }

    private void logTypeRegistrationDetails() {
        int registeredTypes = this.getNumberOfRegisteredTypes();
        int defaultKryoSerializers = this.getNumberOfDefaultKryoSerializers();
        LOG.info("The job has {} registered types and {} default Kryo serializers", (Object)registeredTypes, (Object)defaultKryoSerializers);
        if (this.config.isForceKryoEnabled() && this.config.isForceAvroEnabled()) {
            LOG.warn("In the ExecutionConfig, both Avro and Kryo are enforced. Using Kryo serializer for serializing POJOs");
        } else if (this.config.isForceKryoEnabled()) {
            LOG.info("Using KryoSerializer for serializing POJOs");
        } else if (this.config.isForceAvroEnabled()) {
            LOG.info("Using AvroSerializer for serializing POJOs");
        }
        if (LOG.isDebugEnabled()) {
            this.logDebuggingTypeDetails();
        }
    }

    private int getNumberOfRegisteredTypes() {
        return this.config.getRegisteredKryoTypes().size() + this.config.getRegisteredPojoTypes().size() + this.config.getRegisteredTypesWithKryoSerializerClasses().size() + this.config.getRegisteredTypesWithKryoSerializers().size();
    }

    private int getNumberOfDefaultKryoSerializers() {
        return this.config.getDefaultKryoSerializers().size() + this.config.getDefaultKryoSerializerClasses().size();
    }

    private void logDebuggingTypeDetails() {
        LOG.debug("Registered Kryo types: {}", (Object)this.config.getRegisteredKryoTypes().toString());
        LOG.debug("Registered Kryo with Serializers types: {}", (Object)this.config.getRegisteredTypesWithKryoSerializers().entrySet().toString());
        LOG.debug("Registered Kryo with Serializer Classes types: {}", (Object)this.config.getRegisteredTypesWithKryoSerializerClasses().entrySet().toString());
        LOG.debug("Registered Kryo default Serializers: {}", (Object)this.config.getDefaultKryoSerializers().entrySet().toString());
        LOG.debug("Registered Kryo default Serializers Classes {}", (Object)this.config.getDefaultKryoSerializerClasses().entrySet().toString());
        LOG.debug("Registered POJO types: {}", (Object)this.config.getRegisteredPojoTypes().toString());
    }
}

