/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.Iterator;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.operators.base.OuterJoinOperatorBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.AbstractMergeIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public abstract class AbstractMergeOuterJoinIterator<T1, T2, O>
extends AbstractMergeIterator<T1, T2, O> {
    private final OuterJoinOperatorBase.OuterJoinType outerJoinType;
    private boolean initialized = false;
    private boolean it1Empty = false;
    private boolean it2Empty = false;

    public AbstractMergeOuterJoinIterator(OuterJoinOperatorBase.OuterJoinType outerJoinType, MutableObjectIterator<T1> input1, MutableObjectIterator<T2> input2, TypeSerializer<T1> serializer1, TypeComparator<T1> comparator1, TypeSerializer<T2> serializer2, TypeComparator<T2> comparator2, TypePairComparator<T1, T2> pairComparator, MemoryManager memoryManager, IOManager ioManager, int numMemoryPages, AbstractInvokable parentTask) throws MemoryAllocationException {
        super(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparator, memoryManager, ioManager, numMemoryPages, parentTask);
        this.outerJoinType = outerJoinType;
    }

    @Override
    public boolean callWithNextKey(FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        int comp;
        if (!this.initialized) {
            this.it1Empty = !this.iterator1.nextKey();
            this.it2Empty = !this.iterator2.nextKey();
            this.initialized = true;
        }
        if (this.it1Empty && this.it2Empty) {
            return false;
        }
        if (this.it2Empty) {
            if (this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.LEFT || this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.FULL) {
                this.joinLeftKeyValuesWithNull(this.iterator1.getValues(), joinFunction, collector);
                this.it1Empty = !this.iterator1.nextKey();
                return true;
            }
            while (this.iterator1.nextKey()) {
            }
            this.it1Empty = true;
            return false;
        }
        if (this.it1Empty) {
            if (this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.RIGHT || this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.FULL) {
                this.joinRightKeyValuesWithNull(this.iterator2.getValues(), joinFunction, collector);
                this.it2Empty = !this.iterator2.nextKey();
                return true;
            }
            while (this.iterator2.nextKey()) {
            }
            this.it2Empty = true;
            return false;
        }
        TypePairComparator comparator = this.pairComparator;
        comparator.setReference(this.iterator1.getCurrent());
        Object current2 = this.iterator2.getCurrent();
        while ((comp = comparator.compareToReference(current2)) != 0) {
            if (comp < 0) {
                if (this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.RIGHT || this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.FULL) {
                    this.joinRightKeyValuesWithNull(this.iterator2.getValues(), joinFunction, collector);
                    this.it2Empty = !this.iterator2.nextKey();
                    return true;
                }
                if (!this.iterator2.nextKey()) {
                    this.joinLeftKeyValuesWithNull(this.iterator1.getValues(), joinFunction, collector);
                    this.it1Empty = !this.iterator1.nextKey();
                    this.it2Empty = true;
                    return true;
                }
                current2 = this.iterator2.getCurrent();
                continue;
            }
            if (this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.LEFT || this.outerJoinType == OuterJoinOperatorBase.OuterJoinType.FULL) {
                this.joinLeftKeyValuesWithNull(this.iterator1.getValues(), joinFunction, collector);
                this.it1Empty = !this.iterator1.nextKey();
                return true;
            }
            if (!this.iterator1.nextKey()) {
                this.joinRightKeyValuesWithNull(this.iterator2.getValues(), joinFunction, collector);
                this.it1Empty = true;
                this.it2Empty = !this.iterator2.nextKey();
                return true;
            }
            comparator.setReference(this.iterator1.getCurrent());
        }
        Iterator values1 = this.iterator1.getValues();
        Iterator values2 = this.iterator2.getValues();
        this.crossMatchingGroup(values1, values2, joinFunction, collector);
        this.it1Empty = !this.iterator1.nextKey();
        this.it2Empty = !this.iterator2.nextKey();
        return true;
    }

    private void joinLeftKeyValuesWithNull(Iterator<T1> values, FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        while (values.hasNext()) {
            T1 next = values.next();
            this.copy1 = this.createCopy(this.serializer1, next, this.copy1);
            joinFunction.join(this.copy1, null, collector);
        }
    }

    private void joinRightKeyValuesWithNull(Iterator<T2> values, FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        while (values.hasNext()) {
            T2 next = values.next();
            this.copy2 = this.createCopy(this.serializer2, next, this.copy2);
            joinFunction.join(null, this.copy2, collector);
        }
    }
}

