/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.HadoopConfigUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="CONFIG_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/conf"})
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Autowired
    private ApplicationConfigService applicationConfigService;

    @Operation(summary="Get config")
    @PostMapping(value={"get"})
    public RestResponse get(Long id) {
        ApplicationConfig config = this.applicationConfigService.get(id);
        return RestResponse.success(config);
    }

    @Operation(summary="Get the flink application conf-template")
    @PostMapping(value={"template"})
    public RestResponse template() {
        String config = this.applicationConfigService.readTemplate();
        return RestResponse.success(config);
    }

    @Operation(summary="List the application configs")
    @PostMapping(value={"list"})
    public RestResponse list(ApplicationConfig config, RestRequest request) {
        IPage<ApplicationConfig> page = this.applicationConfigService.page(config, request);
        return RestResponse.success(page);
    }

    @Operation(summary="List application config histories")
    @PostMapping(value={"history"})
    public RestResponse history(Application application) {
        List<ApplicationConfig> history = this.applicationConfigService.history(application);
        return RestResponse.success(history);
    }

    @Operation(summary="Delete config")
    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"conf:delete"})
    public RestResponse delete(Long id) {
        Boolean deleted = this.applicationConfigService.removeById(id);
        return RestResponse.success(deleted);
    }

    @Operation(summary="Get system hadoop configs")
    @PostMapping(value={"sysHadoopConf"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse getSystemHadoopConfig() {
        ImmutableMap result = ImmutableMap.of((Object)"hadoop", (Object)HadoopConfigUtils.readSystemHadoopConf(), (Object)"hive", (Object)HadoopConfigUtils.readSystemHiveConf());
        return RestResponse.success(result);
    }
}

