/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Nullable;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.SavePointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SAVEPOINT_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/savepoint"})
public class SavePointController {
    private static final Logger log = LoggerFactory.getLogger(SavePointController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private SavePointService savePointService;

    @Operation(summary="Get application savepoint latest")
    @PostMapping(value={"latest"})
    public RestResponse latest(Long appId) {
        SavePoint savePoint = this.savePointService.getLatest(appId);
        return RestResponse.success(savePoint);
    }

    @Operation(summary="List application savepoint histories")
    @PostMapping(value={"history"})
    public RestResponse history(SavePoint savePoint, RestRequest request) {
        IPage<SavePoint> page = this.savePointService.page(savePoint, request);
        return RestResponse.success(page);
    }

    @Operation(summary="Delete savepoint")
    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"savepoint:delete"})
    public RestResponse delete(Long id) throws InternalException {
        SavePoint savePoint = (SavePoint)this.savePointService.getById(id);
        Application application = (Application)this.applicationService.getById(savePoint.getAppId());
        Boolean deleted = this.savePointService.delete(id, application);
        return RestResponse.success(deleted);
    }

    @Operation(summary="Trigger savepoint", description="trigger savepoint for specified application")
    @Parameters(value={@Parameter(name="appId", description="app id", required=true, example="100000", schema=@Schema(implementation=Long.class)), @Parameter(name="savepointPath", description="specified savepoint path", schema=@Schema(implementation=String.class))})
    @ApiAccess
    @PostMapping(value={"trigger"})
    @RequiresPermissions(value={"savepoint:trigger"})
    public RestResponse trigger(Long appId, @Nullable String savepointPath) {
        this.savePointService.trigger(appId, savepointPath);
        return RestResponse.success(true);
    }
}

