/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.Template;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.net.util.Base64;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.util.FreemarkerUtils;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertLarkParams;
import org.apache.streampark.console.core.bean.AlertLarkRobotResponse;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.service.alert.AlertNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Lazy
public class LarkAlertNotifyServiceImpl
implements AlertNotifyService {
    private static final Logger log = LoggerFactory.getLogger(LarkAlertNotifyServiceImpl.class);
    private Template template;
    private final RestTemplate alertRestTemplate;
    private final ObjectMapper mapper;
    @Value(value="${streampark.proxy.lark-url:https://open.feishu.cn}")
    private String larkProxyUrl;

    public LarkAlertNotifyServiceImpl(RestTemplate alertRestTemplate, ObjectMapper mapper) {
        this.alertRestTemplate = alertRestTemplate;
        this.mapper = mapper;
    }

    @PostConstruct
    public void loadTemplateFile() {
        String template = "alert-lark.ftl";
        this.template = FreemarkerUtils.loadTemplateFile(template);
    }

    @Override
    public boolean doAlert(AlertConfigWithParams alertConfig, AlertTemplate alertTemplate) throws AlertException {
        AlertLarkParams alertLarkParams = alertConfig.getLarkParams();
        if (alertLarkParams.getIsAtAll().booleanValue()) {
            alertTemplate.setAtAll(true);
        }
        try {
            String markdown = FreemarkerUtils.format(this.template, alertTemplate);
            Map cardMap = (Map)this.mapper.readValue(markdown, (TypeReference)new TypeReference<Map<String, Object>>(){});
            HashMap<String, Object> body = new HashMap<String, Object>();
            if (alertLarkParams.getSecretEnable().booleanValue()) {
                long timestamp = System.currentTimeMillis() / 1000L;
                String sign = this.getSign(alertLarkParams.getSecretToken(), timestamp);
                body.put("timestamp", timestamp);
                body.put("sign", sign);
            }
            body.put("msg_type", "interactive");
            body.put("card", cardMap);
            this.sendMessage(alertLarkParams, body);
            return true;
        }
        catch (AlertException alertException) {
            throw alertException;
        }
        catch (Exception e) {
            throw new AlertException("Failed send lark alert", e);
        }
    }

    private void sendMessage(AlertLarkParams params, Map<String, Object> body) throws AlertException {
        AlertLarkRobotResponse robotResponse;
        String url = this.getWebhook(params);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            robotResponse = (AlertLarkRobotResponse)this.alertRestTemplate.postForObject(url, (Object)entity, AlertLarkRobotResponse.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to request Lark robot alarm,\nurl:{}", (Object)url, (Object)e);
            throw new AlertException(String.format("Failed to request Lark robot alert,\nurl:%s", url), e);
        }
        if (robotResponse == null) {
            throw new AlertException(String.format("Failed to request Lark robot alert,\nurl:%s", url));
        }
        if (robotResponse.getStatusCode() == null || robotResponse.getStatusCode() != 0) {
            throw new AlertException(String.format("Failed to request Lark robot alert,\nurl:%s,\nerrorCode:%d,\nerrorMsg:%s", url, robotResponse.getCode(), robotResponse.getMsg()));
        }
    }

    private String getWebhook(AlertLarkParams params) {
        String url = String.format(this.larkProxyUrl + "/open-apis/bot/v2/hook/%s", params.getToken());
        if (log.isDebugEnabled()) {
            log.debug("The alarm robot url of Lark is {}", (Object)url);
        }
        return url;
    }

    private String getSign(String secret, Long timestamp) throws AlertException {
        try {
            String stringToSign = timestamp + "\n" + secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(stringToSign.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(new byte[0]);
            String sign = new String(Base64.encodeBase64((byte[])signData));
            if (log.isDebugEnabled()) {
                log.debug("Calculate the signature success, sign:{}", (Object)sign);
            }
            return sign;
        }
        catch (Exception e) {
            throw new AlertException("Calculate the signature failed.", e);
        }
    }
}

