/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroRealm
extends AuthorizingRealm {
    @Autowired
    private UserService userService;
    @Autowired
    private AccessTokenService accessTokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JWTToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection token) {
        Long userId = JWTUtil.getUserId(token.toString());
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        Set<String> permissionSet = this.userService.getPermissions(userId, null);
        simpleAuthorizationInfo.setStringPermissions(permissionSet);
        return simpleAuthorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String token = (String)authenticationToken.getCredentials();
        String username = JWTUtil.getUserName(token);
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AuthenticationException("Token verification failed");
        }
        User user = this.userService.findByName(username);
        if (user == null) {
            throw new AuthenticationException("ERROR Incorrect username or password!");
        }
        if (!JWTUtil.verify(token, username)) {
            String tokenDb = WebUtils.encryptToken(token);
            boolean effective = this.accessTokenService.checkTokenEffective(user.getUserId(), tokenDb);
            if (!effective) {
                throw new AuthenticationException("Token checked failed: 1-[Browser Request] please check the username or password; 2-[Api Request] please check the user status or accessToken status");
            }
            SecurityUtils.getSubject().getSession().setAttribute((Object)"is_api_token", (Object)true);
        }
        return new SimpleAuthenticationInfo((Object)token, (Object)token, "streampark_shiro_realm");
    }
}

