/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.BigDecSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class BigDecComparator
extends BasicTypeComparator<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private static final long SMALLEST_MAGNITUDE = Integer.MAX_VALUE;
    private static final long LARGEST_MAGNITUDE = -4294967294L;

    public BigDecComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        BigDecimal bd1 = BigDecSerializer.readBigDecimal(firstSource);
        BigDecimal bd2 = BigDecSerializer.readBigDecimal(secondSource);
        int comp = bd1.compareTo(bd2);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 5;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    @Override
    public void putNormalizedKey(BigDecimal record, MemorySegment target, int offset, int len) {
        long signNormMag;
        long signum = record.signum();
        long mag = (long)record.scale() - (long)record.precision() + 1L;
        long normMag = 0xFFFFFFFEL + mag;
        long l = signNormMag = signum < 0L ? normMag : 6442450941L - normMag;
        if (signum == 0L) {
            signNormMag = 0L;
            signNormMag |= 0x400000000L;
        } else if (signum > 0L) {
            signNormMag |= 0x800000000L;
        }
        for (int i = 0; i < 5 && len > 0; ++i, --len) {
            byte b = (byte)(signNormMag >>> 8 * (4 - i));
            target.put(offset++, b);
        }
    }

    public BigDecComparator duplicate() {
        return new BigDecComparator(this.ascendingComparison);
    }
}

