/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

public final class LambdaUtil {
    private LambdaUtil() {
        throw new AssertionError();
    }

    public static <T> void applyToAllWhileSuppressingExceptions(Iterable<T> inputs, ThrowingConsumer<T, ? extends Exception> throwingConsumer) throws Exception {
        if (inputs != null && throwingConsumer != null) {
            Exception exception = null;
            for (T input : inputs) {
                if (input == null) continue;
                try {
                    throwingConsumer.accept(input);
                }
                catch (Exception ex) {
                    exception = ExceptionUtils.firstOrSuppressed(ex, exception);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public static <E extends Throwable> void withContextClassLoader(ClassLoader cl, ThrowingRunnable<E> r) throws E {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(cl);){
            r.run();
        }
    }

    public static <R, E extends Throwable> R withContextClassLoader(ClassLoader cl, SupplierWithException<R, E> s) throws E {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(cl);){
            R r = s.get();
            return r;
        }
    }
}

