/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.DefaultApplicationContextFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

@FunctionalInterface
public interface ApplicationContextFactory {
    public static final ApplicationContextFactory DEFAULT = new DefaultApplicationContextFactory();

    default public Class<? extends ConfigurableEnvironment> getEnvironmentType(WebApplicationType webApplicationType) {
        return null;
    }

    default public ConfigurableEnvironment createEnvironment(WebApplicationType webApplicationType) {
        return null;
    }

    public ConfigurableApplicationContext create(WebApplicationType var1);

    public static ApplicationContextFactory ofContextClass(Class<? extends ConfigurableApplicationContext> contextClass) {
        return ApplicationContextFactory.of(() -> (ConfigurableApplicationContext)BeanUtils.instantiateClass((Class)contextClass));
    }

    public static ApplicationContextFactory of(Supplier<ConfigurableApplicationContext> supplier) {
        return webApplicationType -> (ConfigurableApplicationContext)supplier.get();
    }
}

