/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.operators.collect.AbstractCollectResultBuffer;
import org.apache.flink.streaming.api.operators.collect.CheckpointedCollectResultBuffer;
import org.apache.flink.streaming.api.operators.collect.CollectResultFetcher;
import org.apache.flink.streaming.api.operators.collect.UncheckpointedCollectResultBuffer;
import org.apache.flink.util.CloseableIterator;

public class CollectResultIterator<T>
implements CloseableIterator<T> {
    private final CollectResultFetcher<T> fetcher;
    private T bufferedResult;

    public CollectResultIterator(CompletableFuture<OperatorID> operatorIdFuture, TypeSerializer<T> serializer, String accumulatorName, CheckpointConfig checkpointConfig) {
        AbstractCollectResultBuffer<T> buffer = this.createBuffer(serializer, checkpointConfig);
        this.fetcher = new CollectResultFetcher<T>(buffer, operatorIdFuture, accumulatorName);
        this.bufferedResult = null;
    }

    @VisibleForTesting
    public CollectResultIterator(AbstractCollectResultBuffer<T> buffer, CompletableFuture<OperatorID> operatorIdFuture, String accumulatorName, int retryMillis) {
        this.fetcher = new CollectResultFetcher<T>(buffer, operatorIdFuture, accumulatorName, retryMillis);
        this.bufferedResult = null;
    }

    public boolean hasNext() {
        if (this.bufferedResult == null) {
            this.bufferedResult = this.nextResultFromFetcher();
        }
        return this.bufferedResult != null;
    }

    public T next() {
        if (this.bufferedResult == null) {
            this.bufferedResult = this.nextResultFromFetcher();
        }
        T ret = this.bufferedResult;
        this.bufferedResult = null;
        return ret;
    }

    public void close() throws Exception {
        this.fetcher.close();
    }

    public void setJobClient(JobClient jobClient) {
        this.fetcher.setJobClient(jobClient);
    }

    private T nextResultFromFetcher() {
        try {
            return this.fetcher.next();
        }
        catch (IOException e) {
            this.fetcher.close();
            throw new RuntimeException("Failed to fetch next result", e);
        }
    }

    private AbstractCollectResultBuffer<T> createBuffer(TypeSerializer<T> serializer, CheckpointConfig checkpointConfig) {
        if (checkpointConfig.isCheckpointingEnabled()) {
            if (checkpointConfig.getCheckpointingMode() == CheckpointingMode.EXACTLY_ONCE) {
                return new CheckpointedCollectResultBuffer<T>(serializer);
            }
            return new UncheckpointedCollectResultBuffer<T>(serializer, true);
        }
        return new UncheckpointedCollectResultBuffer<T>(serializer, false);
    }
}

