/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.ExternallyInducedSourceReader;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.metrics.groups.InternalSourceReaderMetricGroup;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamOneInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskExternallyInducedSourceInput;
import org.apache.flink.streaming.runtime.io.StreamTaskSourceInput;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskFinishedOnRestoreSourceInput;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

@Internal
public class SourceOperatorStreamTask<T>
extends StreamTask<T, SourceOperator<T, ?>> {
    private AsyncDataOutputToOutput<T> output;
    private boolean isExternallyInducedSource;

    public SourceOperatorStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    public void init() throws Exception {
        StreamTaskSourceInput input;
        SourceOperator sourceOperator = (SourceOperator)this.mainOperator;
        sourceOperator.initReader();
        SourceReader sourceReader = sourceOperator.getSourceReader();
        if (this.operatorChain.isTaskDeployedAsFinished()) {
            input = new StreamTaskFinishedOnRestoreSourceInput(sourceOperator, 0, 0);
        } else if (sourceReader instanceof ExternallyInducedSourceReader) {
            this.isExternallyInducedSource = true;
            input = new StreamTaskExternallyInducedSourceInput(sourceOperator, this::triggerCheckpointForExternallyInducedSource, 0, 0);
        } else {
            input = new StreamTaskSourceInput(sourceOperator, 0, 0);
        }
        this.output = new AsyncDataOutputToOutput(this.operatorChain.getMainOperatorOutput(), sourceOperator.getSourceMetricGroup(), null);
        this.inputProcessor = new StreamOneInputProcessor(input, this.output, this.operatorChain);
        this.getEnvironment().getMetricGroup().getIOMetricGroup().gauge("checkpointStartDelayNanos", this::getAsyncCheckpointStartDelayNanos);
    }

    @Override
    protected void finishTask() throws Exception {
        this.mailboxProcessor.allActionsCompleted();
    }

    @Override
    public CompletableFuture<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        if (!this.isExternallyInducedSource) {
            if (checkpointOptions.getCheckpointType().shouldDrain()) {
                return this.triggerStopWithSavepointWithDrainAsync(checkpointMetaData, checkpointOptions);
            }
            return super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions);
        }
        return CompletableFuture.completedFuture(this.isRunning());
    }

    private CompletableFuture<Boolean> triggerStopWithSavepointWithDrainAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        CompletableFuture operatorFinished = new CompletableFuture();
        this.mainMailboxExecutor.execute(() -> {
            this.setSynchronousSavepoint(checkpointMetaData.getCheckpointId(), true);
            FutureUtils.forward(((SourceOperator)this.mainOperator).stop(), (CompletableFuture)operatorFinished);
        }, "stop Flip-27 source for stop-with-savepoint --drain");
        return this.assertTriggeringCheckpointExceptions((CompletableFuture<Boolean>)operatorFinished.thenCompose(ignore -> super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions)), checkpointMetaData.getCheckpointId());
    }

    @Override
    protected void advanceToEndOfEventTime() {
        this.output.emitWatermark(Watermark.MAX_WATERMARK);
    }

    private void triggerCheckpointForExternallyInducedSource(long checkpointId) {
        CheckpointOptions checkpointOptions = CheckpointOptions.forConfig((CheckpointType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault(), (boolean)this.configuration.isExactlyOnceCheckpointMode(), (boolean)this.configuration.isUnalignedCheckpointsEnabled(), (long)this.configuration.getAlignedCheckpointTimeout().toMillis());
        long timestamp = System.currentTimeMillis();
        CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointId, timestamp, timestamp);
        super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions);
    }

    public static class AsyncDataOutputToOutput<T>
    implements PushingAsyncDataInput.DataOutput<T> {
        private final Output<StreamRecord<T>> output;
        private final InternalSourceReaderMetricGroup metricGroup;
        @Nullable
        private final WatermarkGauge inputWatermarkGauge;
        private final Counter numRecordsOut;

        public AsyncDataOutputToOutput(Output<StreamRecord<T>> output, InternalSourceReaderMetricGroup metricGroup, @Nullable WatermarkGauge inputWatermarkGauge) {
            this.output = (Output)Preconditions.checkNotNull(output);
            this.numRecordsOut = metricGroup.getIOMetricGroup().getNumRecordsOutCounter();
            this.inputWatermarkGauge = inputWatermarkGauge;
            this.metricGroup = metricGroup;
        }

        @Override
        public void emitRecord(StreamRecord<T> streamRecord) {
            this.numRecordsOut.inc();
            this.metricGroup.recordEmitted(streamRecord.getTimestamp());
            this.output.collect(streamRecord);
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            this.output.emitLatencyMarker(latencyMarker);
        }

        @Override
        public void emitWatermark(Watermark watermark) {
            long watermarkTimestamp = watermark.getTimestamp();
            if (this.inputWatermarkGauge != null) {
                this.inputWatermarkGauge.setCurrentWatermark(watermarkTimestamp);
            }
            this.metricGroup.watermarkEmitted(watermarkTimestamp);
            this.output.emitWatermark(watermark);
        }

        @Override
        public void emitWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
            this.output.emitWatermarkStatus(watermarkStatus);
        }
    }
}

