/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Base64;
import java.util.Date;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.console.core.bean.MavenDependency;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.ChangedType;

@TableName(value="t_flink_sql")
public class FlinkSql {
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long appId;
    @TableField(value="`sql`")
    private String sql;
    private String dependency;
    private Integer version = 1;
    private Integer candidate;
    private Date createTime;
    private transient boolean effective = false;
    private transient boolean sqlDifference = false;
    private transient boolean dependencyDifference = false;

    public FlinkSql() {
    }

    public FlinkSql(Application application) {
        this.appId = application.getId();
        this.sql = application.getFlinkSql();
        this.dependency = application.getDependency();
        this.createTime = new Date();
    }

    public void decode() {
        this.setSql(DeflaterUtils.unzipString((String)this.sql));
    }

    public void setToApplication(Application application) {
        String encode = Base64.getEncoder().encodeToString(this.sql.getBytes());
        application.setFlinkSql(encode);
        application.setDependency(this.dependency);
        application.setSqlId(this.id);
    }

    public ChangedType checkChange(FlinkSql target) {
        boolean depDifference;
        boolean sqlDifference = !this.getSql().trim().equals(target.getSql().trim());
        MavenDependency thisDependency = MavenDependency.of(this.getDependency());
        MavenDependency targetDependency = MavenDependency.of(target.getDependency());
        boolean bl = depDifference = !thisDependency.equals(targetDependency);
        if (sqlDifference && depDifference) {
            return ChangedType.ALL;
        }
        if (sqlDifference) {
            return ChangedType.SQL;
        }
        if (depDifference) {
            return ChangedType.DEPENDENCY;
        }
        return ChangedType.NONE;
    }

    public void base64Encode() {
        this.sql = Base64.getEncoder().encodeToString(DeflaterUtils.unzipString((String)this.sql).getBytes());
    }

    public Long getId() {
        return this.id;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getSql() {
        return this.sql;
    }

    public String getDependency() {
        return this.dependency;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getCandidate() {
        return this.candidate;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public boolean isSqlDifference() {
        return this.sqlDifference;
    }

    public boolean isDependencyDifference() {
        return this.dependencyDifference;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setCandidate(Integer candidate) {
        this.candidate = candidate;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setEffective(boolean effective) {
        this.effective = effective;
    }

    public void setSqlDifference(boolean sqlDifference) {
        this.sqlDifference = sqlDifference;
    }

    public void setDependencyDifference(boolean dependencyDifference) {
        this.dependencyDifference = dependencyDifference;
    }
}

