/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SavepointRequestTrait;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import org.apache.streampark.flink.client.trait.KubernetesNativeClientTrait;
import org.apache.streampark.flink.packer.pipeline.DockerImageBuildResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;

public final class KubernetesNativeApplicationClient$
implements KubernetesNativeClientTrait {
    public static KubernetesNativeApplicationClient$ MODULE$;
    private String PARAM_KEY_FLINK_CONF;
    private String PARAM_KEY_FLINK_SQL;
    private String PARAM_KEY_APP_CONF;
    private String PARAM_KEY_APP_NAME;
    private String PARAM_KEY_FLINK_PARALLELISM;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new KubernetesNativeApplicationClient$();
    }

    @Override
    public /* synthetic */ String org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait.cancelJob$(this, cancelRequest, jobID, client);
    }

    @Override
    public /* synthetic */ String org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest, jobID, client);
    }

    @Override
    public void setConfig(SubmitRequest submitRequest, Configuration flinkConfig) {
        KubernetesNativeClientTrait.setConfig$(this, submitRequest, flinkConfig);
    }

    @Override
    public <O, R extends SavepointRequestTrait> O executeClientAction(R request, Configuration flinkConfig, Function2<JobID, ClusterClient<?>, O> actFunc) {
        return (O)KubernetesNativeClientTrait.executeClientAction$(this, request, flinkConfig, actFunc);
    }

    @Override
    public Tuple2<KubernetesClusterDescriptor, ClusterSpecification> getK8sClusterDescriptorAndSpecification(Configuration flinkConfig) {
        return KubernetesNativeClientTrait.getK8sClusterDescriptorAndSpecification$(this, flinkConfig);
    }

    @Override
    public KubernetesClusterDescriptor getK8sClusterDescriptor(Configuration flinkConfig) {
        return KubernetesNativeClientTrait.getK8sClusterDescriptor$(this, flinkConfig);
    }

    @Override
    public String flinkConfIdentifierInfo(@Nonnull Configuration conf) {
        return KubernetesNativeClientTrait.flinkConfIdentifierInfo$(this, conf);
    }

    @Override
    public String getDefaultKubernetesConf(String k8sConf) {
        return KubernetesNativeClientTrait.getDefaultKubernetesConf$(this, k8sConf);
    }

    @Override
    public SubmitResponse submit(SubmitRequest submitRequest) throws Exception {
        return FlinkClientTrait.submit$(this, submitRequest);
    }

    @Override
    public SavepointResponse triggerSavepoint(TriggerSavepointRequest savepointRequest) throws Exception {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest);
    }

    @Override
    public CancelResponse cancel(CancelRequest cancelRequest) throws Exception {
        return FlinkClientTrait.cancel$(this, cancelRequest);
    }

    @Override
    public SubmitResponse trySubmit(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile, Function3<SubmitRequest, Configuration, File, SubmitResponse> jobGraphFunc, Function3<SubmitRequest, Configuration, File, SubmitResponse> restApiFunc) {
        return FlinkClientTrait.trySubmit$(this, submitRequest, flinkConfig, jarFile, jobGraphFunc, restApiFunc);
    }

    @Override
    public Tuple2<PackagedProgram, JobGraph> getJobGraph(Configuration flinkConfig, SubmitRequest submitRequest, File jarFile) {
        return FlinkClientTrait.getJobGraph$(this, flinkConfig, submitRequest, jarFile);
    }

    @Override
    public JobID getJobID(String jobId) {
        return FlinkClientTrait.getJobID$(this, jobId);
    }

    @Override
    public CustomCommandLine validateAndGetActiveCommandLine(List<CustomCommandLine> customCommandLines, CommandLine commandLine) {
        return FlinkClientTrait.validateAndGetActiveCommandLine$(this, customCommandLines, commandLine);
    }

    @Override
    public Configuration getFlinkDefaultConfiguration(String flinkHome) {
        return FlinkClientTrait.getFlinkDefaultConfiguration$(this, flinkHome);
    }

    @Override
    public <T> T getOptionFromDefaultFlinkConfig(String flinkHome, ConfigOption<T> option) {
        return (T)FlinkClientTrait.getOptionFromDefaultFlinkConfig$(this, flinkHome, option);
    }

    @Override
    public Integer getParallelism(SubmitRequest submitRequest) {
        return FlinkClientTrait.getParallelism$(this, submitRequest);
    }

    @Override
    public Options getCommandLineOptions(String flinkHome) {
        return FlinkClientTrait.getCommandLineOptions$(this, flinkHome);
    }

    @Override
    public Configuration extractConfiguration(String flinkHome, Map<String, Object> properties) {
        return FlinkClientTrait.extractConfiguration$(this, flinkHome, properties);
    }

    @Override
    public FlinkClientTrait.EnhanceFlinkConfiguration EnhanceFlinkConfiguration(Configuration flinkConfig) {
        return FlinkClientTrait.EnhanceFlinkConfiguration$(this, flinkConfig);
    }

    @Override
    public String cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait.cancelJob$(this, cancelRequest, jobID, client);
    }

    @Override
    public String triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest, jobID, client);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    private String PARAM_KEY_FLINK_CONF$lzycompute() {
        KubernetesNativeApplicationClient$ kubernetesNativeApplicationClient$ = this;
        synchronized (kubernetesNativeApplicationClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PARAM_KEY_FLINK_CONF = FlinkClientTrait.PARAM_KEY_FLINK_CONF$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.PARAM_KEY_FLINK_CONF;
    }

    @Override
    public String PARAM_KEY_FLINK_CONF() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PARAM_KEY_FLINK_CONF$lzycompute() : this.PARAM_KEY_FLINK_CONF;
    }

    private String PARAM_KEY_FLINK_SQL$lzycompute() {
        KubernetesNativeApplicationClient$ kubernetesNativeApplicationClient$ = this;
        synchronized (kubernetesNativeApplicationClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.PARAM_KEY_FLINK_SQL = FlinkClientTrait.PARAM_KEY_FLINK_SQL$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.PARAM_KEY_FLINK_SQL;
    }

    @Override
    public String PARAM_KEY_FLINK_SQL() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.PARAM_KEY_FLINK_SQL$lzycompute() : this.PARAM_KEY_FLINK_SQL;
    }

    private String PARAM_KEY_APP_CONF$lzycompute() {
        KubernetesNativeApplicationClient$ kubernetesNativeApplicationClient$ = this;
        synchronized (kubernetesNativeApplicationClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.PARAM_KEY_APP_CONF = FlinkClientTrait.PARAM_KEY_APP_CONF$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.PARAM_KEY_APP_CONF;
    }

    @Override
    public String PARAM_KEY_APP_CONF() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.PARAM_KEY_APP_CONF$lzycompute() : this.PARAM_KEY_APP_CONF;
    }

    private String PARAM_KEY_APP_NAME$lzycompute() {
        KubernetesNativeApplicationClient$ kubernetesNativeApplicationClient$ = this;
        synchronized (kubernetesNativeApplicationClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.PARAM_KEY_APP_NAME = FlinkClientTrait.PARAM_KEY_APP_NAME$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.PARAM_KEY_APP_NAME;
    }

    @Override
    public String PARAM_KEY_APP_NAME() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.PARAM_KEY_APP_NAME$lzycompute() : this.PARAM_KEY_APP_NAME;
    }

    private String PARAM_KEY_FLINK_PARALLELISM$lzycompute() {
        KubernetesNativeApplicationClient$ kubernetesNativeApplicationClient$ = this;
        synchronized (kubernetesNativeApplicationClient$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.PARAM_KEY_FLINK_PARALLELISM = FlinkClientTrait.PARAM_KEY_FLINK_PARALLELISM$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.PARAM_KEY_FLINK_PARALLELISM;
    }

    @Override
    public String PARAM_KEY_FLINK_PARALLELISM() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.PARAM_KEY_FLINK_PARALLELISM$lzycompute() : this.PARAM_KEY_FLINK_PARALLELISM;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private /* synthetic */ String super$cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait.cancelJob$(this, cancelRequest, jobID, client);
    }

    @Override
    public SubmitResponse doSubmit(SubmitRequest submitRequest, Configuration flinkConfig) throws Exception {
        SubmitResponse submitResponse;
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)submitRequest.clusterId()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("[flink-submit] submit flink job failed, clusterId is null, mode=").append(flinkConfig.get(DeploymentOptions.TARGET)).toString());
        submitRequest.checkBuildResult();
        DockerImageBuildResponse buildResult = (DockerImageBuildResponse)submitRequest.buildResult();
        this.EnhanceFlinkConfiguration(flinkConfig).safeSet(PipelineOptions.JARS, Lists.newArrayList((Object[])new String[]{buildResult.dockerInnerMainJarPath()}));
        this.EnhanceFlinkConfiguration(flinkConfig).safeSet(KubernetesConfigOptions.CONTAINER_IMAGE, buildResult.flinkImageTag());
        KubernetesClusterDescriptor clusterDescriptor = null;
        ClusterClient clusterClient = null;
        try {
            try {
                Tuple2<KubernetesClusterDescriptor, ClusterSpecification> tuple2 = this.getK8sClusterDescriptorAndSpecification(flinkConfig);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                KubernetesClusterDescriptor descriptor = (KubernetesClusterDescriptor)tuple2._1();
                ClusterSpecification clusterSpecification = (ClusterSpecification)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)descriptor, (Object)clusterSpecification);
                Tuple2 tuple23 = tuple22;
                KubernetesClusterDescriptor descriptor2 = (KubernetesClusterDescriptor)tuple23._1();
                ClusterSpecification clusterSpecification2 = (ClusterSpecification)tuple23._2();
                clusterDescriptor = descriptor2;
                ApplicationConfiguration applicationConfig = ApplicationConfiguration.fromConfiguration((Configuration)flinkConfig);
                clusterClient = clusterDescriptor.deployApplicationCluster(clusterSpecification2, applicationConfig).getClusterClient();
                String clusterId = (String)clusterClient.getClusterId();
                SubmitResponse result = new SubmitResponse(clusterId, flinkConfig.toMap(), submitRequest.jobId(), clusterClient.getWebInterfaceURL());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("[flink-submit] flink job has been submitted. ").append(MODULE$.flinkConfIdentifierInfo(flinkConfig)).toString());
                submitResponse = result;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("submit flink job fail in ").append(submitRequest.executionMode()).append(" mode").toString());
                throw e;
            }
        }
        catch (Throwable throwable) {
            KubernetesClusterDescriptor x$1 = clusterDescriptor;
            ClusterClient x$2 = clusterClient;
            Function1 x$3 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$1, x$2}));
            Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$1, x$2}), x$3);
            throw throwable;
        }
        KubernetesClusterDescriptor x$1 = clusterDescriptor;
        ClusterClient x$2 = clusterClient;
        Function1 x$3 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$1, x$2}));
        Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$1, x$2}), x$3);
        return submitResponse;
    }

    @Override
    public CancelResponse doCancel(CancelRequest cancelRequest, Configuration flinkConf) {
        this.EnhanceFlinkConfiguration(flinkConf).safeSet(DeploymentOptions.TARGET, ExecutionMode.KUBERNETES_NATIVE_APPLICATION.getName());
        return (CancelResponse)this.executeClientAction(cancelRequest, flinkConf, (Function2 & Serializable & scala.Serializable)(jobId, client) -> {
            String resp = MODULE$.super$cancelJob(cancelRequest, (JobID)jobId, (ClusterClient)client);
            client.shutDownCluster();
            return new CancelResponse(resp);
        });
    }

    @Override
    public SavepointResponse doTriggerSavepoint(TriggerSavepointRequest request, Configuration flinkConf) {
        this.EnhanceFlinkConfiguration(flinkConf).safeSet(DeploymentOptions.TARGET, ExecutionMode.KUBERNETES_NATIVE_APPLICATION.getName());
        return KubernetesNativeClientTrait.doTriggerSavepoint$(this, request, flinkConf);
    }

    private KubernetesNativeApplicationClient$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
        FlinkClientTrait.$init$(this);
        KubernetesNativeClientTrait.$init$(this);
    }
}

