/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.impl;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClientFactory;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.AbstractID;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.DeployResponse$;
import org.apache.streampark.flink.client.bean.KubernetesDeployRequest;
import org.apache.streampark.flink.client.bean.SavepointRequestTrait;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.apache.streampark.flink.client.bean.ShutDownResponse$;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.tool.FlinkSessionSubmitHelper$;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import org.apache.streampark.flink.client.trait.KubernetesNativeClientTrait;
import org.apache.streampark.flink.core.FlinkKubernetesClient;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesNativeSessionClient$
implements KubernetesNativeClientTrait {
    public static KubernetesNativeSessionClient$ MODULE$;
    private String PARAM_KEY_FLINK_CONF;
    private String PARAM_KEY_FLINK_SQL;
    private String PARAM_KEY_APP_CONF;
    private String PARAM_KEY_APP_NAME;
    private String PARAM_KEY_FLINK_PARALLELISM;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new KubernetesNativeSessionClient$();
    }

    @Override
    public /* synthetic */ String org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait.cancelJob$(this, cancelRequest, jobID, client);
    }

    @Override
    public /* synthetic */ String org$apache$streampark$flink$client$trait$KubernetesNativeClientTrait$$super$triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient client) {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest, jobID, client);
    }

    @Override
    public void setConfig(SubmitRequest submitRequest, Configuration flinkConfig) {
        KubernetesNativeClientTrait.setConfig$(this, submitRequest, flinkConfig);
    }

    @Override
    public <O, R extends SavepointRequestTrait> O executeClientAction(R request, Configuration flinkConfig, Function2<JobID, ClusterClient<?>, O> actFunc) {
        return (O)KubernetesNativeClientTrait.executeClientAction$(this, request, flinkConfig, actFunc);
    }

    @Override
    public Tuple2<KubernetesClusterDescriptor, ClusterSpecification> getK8sClusterDescriptorAndSpecification(Configuration flinkConfig) {
        return KubernetesNativeClientTrait.getK8sClusterDescriptorAndSpecification$(this, flinkConfig);
    }

    @Override
    public KubernetesClusterDescriptor getK8sClusterDescriptor(Configuration flinkConfig) {
        return KubernetesNativeClientTrait.getK8sClusterDescriptor$(this, flinkConfig);
    }

    @Override
    public String flinkConfIdentifierInfo(@Nonnull Configuration conf) {
        return KubernetesNativeClientTrait.flinkConfIdentifierInfo$(this, conf);
    }

    @Override
    public String getDefaultKubernetesConf(String k8sConf) {
        return KubernetesNativeClientTrait.getDefaultKubernetesConf$(this, k8sConf);
    }

    @Override
    public SubmitResponse submit(SubmitRequest submitRequest) throws Exception {
        return FlinkClientTrait.submit$(this, submitRequest);
    }

    @Override
    public SavepointResponse triggerSavepoint(TriggerSavepointRequest savepointRequest) throws Exception {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest);
    }

    @Override
    public CancelResponse cancel(CancelRequest cancelRequest) throws Exception {
        return FlinkClientTrait.cancel$(this, cancelRequest);
    }

    @Override
    public SubmitResponse trySubmit(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile, Function3<SubmitRequest, Configuration, File, SubmitResponse> jobGraphFunc, Function3<SubmitRequest, Configuration, File, SubmitResponse> restApiFunc) {
        return FlinkClientTrait.trySubmit$(this, submitRequest, flinkConfig, jarFile, jobGraphFunc, restApiFunc);
    }

    @Override
    public Tuple2<PackagedProgram, JobGraph> getJobGraph(Configuration flinkConfig, SubmitRequest submitRequest, File jarFile) {
        return FlinkClientTrait.getJobGraph$(this, flinkConfig, submitRequest, jarFile);
    }

    @Override
    public JobID getJobID(String jobId) {
        return FlinkClientTrait.getJobID$(this, jobId);
    }

    @Override
    public CustomCommandLine validateAndGetActiveCommandLine(List<CustomCommandLine> customCommandLines, CommandLine commandLine) {
        return FlinkClientTrait.validateAndGetActiveCommandLine$(this, customCommandLines, commandLine);
    }

    @Override
    public Configuration getFlinkDefaultConfiguration(String flinkHome) {
        return FlinkClientTrait.getFlinkDefaultConfiguration$(this, flinkHome);
    }

    @Override
    public <T> T getOptionFromDefaultFlinkConfig(String flinkHome, ConfigOption<T> option) {
        return (T)FlinkClientTrait.getOptionFromDefaultFlinkConfig$(this, flinkHome, option);
    }

    @Override
    public Integer getParallelism(SubmitRequest submitRequest) {
        return FlinkClientTrait.getParallelism$(this, submitRequest);
    }

    @Override
    public Options getCommandLineOptions(String flinkHome) {
        return FlinkClientTrait.getCommandLineOptions$(this, flinkHome);
    }

    @Override
    public Configuration extractConfiguration(String flinkHome, Map<String, Object> properties) {
        return FlinkClientTrait.extractConfiguration$(this, flinkHome, properties);
    }

    @Override
    public FlinkClientTrait.EnhanceFlinkConfiguration EnhanceFlinkConfiguration(Configuration flinkConfig) {
        return FlinkClientTrait.EnhanceFlinkConfiguration$(this, flinkConfig);
    }

    @Override
    public String cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait.cancelJob$(this, cancelRequest, jobID, client);
    }

    @Override
    public String triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest, jobID, client);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    private String PARAM_KEY_FLINK_CONF$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PARAM_KEY_FLINK_CONF = FlinkClientTrait.PARAM_KEY_FLINK_CONF$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.PARAM_KEY_FLINK_CONF;
    }

    @Override
    public String PARAM_KEY_FLINK_CONF() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PARAM_KEY_FLINK_CONF$lzycompute() : this.PARAM_KEY_FLINK_CONF;
    }

    private String PARAM_KEY_FLINK_SQL$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.PARAM_KEY_FLINK_SQL = FlinkClientTrait.PARAM_KEY_FLINK_SQL$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.PARAM_KEY_FLINK_SQL;
    }

    @Override
    public String PARAM_KEY_FLINK_SQL() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.PARAM_KEY_FLINK_SQL$lzycompute() : this.PARAM_KEY_FLINK_SQL;
    }

    private String PARAM_KEY_APP_CONF$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.PARAM_KEY_APP_CONF = FlinkClientTrait.PARAM_KEY_APP_CONF$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.PARAM_KEY_APP_CONF;
    }

    @Override
    public String PARAM_KEY_APP_CONF() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.PARAM_KEY_APP_CONF$lzycompute() : this.PARAM_KEY_APP_CONF;
    }

    private String PARAM_KEY_APP_NAME$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.PARAM_KEY_APP_NAME = FlinkClientTrait.PARAM_KEY_APP_NAME$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.PARAM_KEY_APP_NAME;
    }

    @Override
    public String PARAM_KEY_APP_NAME() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.PARAM_KEY_APP_NAME$lzycompute() : this.PARAM_KEY_APP_NAME;
    }

    private String PARAM_KEY_FLINK_PARALLELISM$lzycompute() {
        KubernetesNativeSessionClient$ kubernetesNativeSessionClient$ = this;
        synchronized (kubernetesNativeSessionClient$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.PARAM_KEY_FLINK_PARALLELISM = FlinkClientTrait.PARAM_KEY_FLINK_PARALLELISM$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.PARAM_KEY_FLINK_PARALLELISM;
    }

    @Override
    public String PARAM_KEY_FLINK_PARALLELISM() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.PARAM_KEY_FLINK_PARALLELISM$lzycompute() : this.PARAM_KEY_FLINK_PARALLELISM;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public SubmitResponse doSubmit(SubmitRequest submitRequest2, Configuration flinkConfig2) throws Exception {
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)submitRequest2.clusterId()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("[flink-submit] submit flink job failed, clusterId is null, mode=").append(flinkConfig2.get(DeploymentOptions.TARGET)).toString());
        return FlinkClientTrait.trySubmit$(this, submitRequest2, flinkConfig2, submitRequest2.userJarFile(), (Function3 & Serializable & scala.Serializable)(submitRequest, flinkConfig, jarFile) -> MODULE$.jobGraphSubmit((SubmitRequest)submitRequest, (Configuration)flinkConfig, (File)jarFile), (Function3 & Serializable & scala.Serializable)(submitRequest, flinkConfig, fatJar) -> MODULE$.restApiSubmit((SubmitRequest)submitRequest, (Configuration)flinkConfig, (File)fatJar));
    }

    public SubmitResponse restApiSubmit(SubmitRequest submitRequest, Configuration flinkConfig, File fatJar) throws Exception {
        SubmitResponse s;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ClusterKey clusterKey = new ClusterKey(FlinkK8sExecuteMode$.MODULE$.SESSION(), submitRequest.kubernetesNamespace(), submitRequest.clusterId());
            String jmRestUrl = (String)KubernetesRetriever$.MODULE$.retrieveFlinkRestUrl(clusterKey).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new StringBuilder(66).append("[flink-submit] retrieve flink session rest url failed, clusterKey=").append(clusterKey).toString());
            });
            String jobId = FlinkSessionSubmitHelper$.MODULE$.submitViaRestApi(jmRestUrl, fatJar, flinkConfig);
            return new SubmitResponse(clusterKey.clusterId(), flinkConfig.toMap(), jobId, jmRestUrl);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("submit flink job fail in ").append(submitRequest.executionMode()).append(" mode").toString());
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        SubmitResponse submitResponse = s = (SubmitResponse)success.value();
        return submitResponse;
    }

    public SubmitResponse jobGraphSubmit(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile) throws Exception {
        SubmitResponse submitResponse;
        KubernetesClusterDescriptor clusterDescriptor = null;
        PackagedProgram packageProgram = null;
        ClusterClient client = null;
        try {
            try {
                clusterDescriptor = this.getK8sClusterDescriptor(flinkConfig);
                Tuple2 packageProgramJobGraph = FlinkClientTrait.getJobGraph$(this, flinkConfig, submitRequest, jarFile);
                packageProgram = (PackagedProgram)packageProgramJobGraph._1();
                JobGraph jobGraph = (JobGraph)packageProgramJobGraph._2();
                client = clusterDescriptor.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient();
                CompletableFuture submitResult = client.submitJob(jobGraph);
                String jobId = ((AbstractID)submitResult.get()).toString();
                SubmitResponse result = new SubmitResponse((String)client.getClusterId(), flinkConfig.toMap(), jobId, client.getWebInterfaceURL());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("[flink-submit] flink job has been submitted. ").append(MODULE$.flinkConfIdentifierInfo(flinkConfig)).append(", jobId: ").append(jobId).toString());
                submitResponse = result;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("submit flink job fail in ").append(submitRequest.executionMode()).append(" mode").toString());
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (submitRequest.safePackageProgram()) {
                Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PackagedProgram[]{packageProgram}));
                Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
                Utils$.MODULE$.close(x$1, x$2);
            }
            KubernetesClusterDescriptor x$3 = clusterDescriptor;
            ClusterClient x$4 = client;
            Function1 x$5 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}));
            Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}), x$5);
            throw throwable;
        }
        if (submitRequest.safePackageProgram()) {
            Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PackagedProgram[]{packageProgram}));
            Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
            Utils$.MODULE$.close(x$1, x$2);
        }
        KubernetesClusterDescriptor x$3 = clusterDescriptor;
        ClusterClient x$4 = client;
        Function1 x$5 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}));
        Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$3, x$4}), x$5);
        return submitResponse;
    }

    @Override
    public CancelResponse doCancel(CancelRequest cancelRequest, Configuration flinkConf) {
        this.EnhanceFlinkConfiguration(flinkConf).safeSet(DeploymentOptions.TARGET, ExecutionMode.KUBERNETES_NATIVE_SESSION.getName());
        return KubernetesNativeClientTrait.doCancel$(this, cancelRequest, flinkConf);
    }

    public DeployResponse deploy(DeployRequest deployReq) throws Exception {
        DeployResponse deployResponse;
        KubernetesDeployRequest deployRequest = (KubernetesDeployRequest)deployReq;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(542).append("\n         |--------------------------------------- kubernetes session cluster start ---------------------------------------\n         |    userFlinkHome    : ").append(deployRequest.flinkVersion().flinkHome()).append("\n         |    flinkVersion     : ").append(deployRequest.flinkVersion().version()).append("\n         |    execMode         : ").append(deployRequest.executionMode().name()).append("\n         |    clusterId        : ").append(deployRequest.clusterId()).append("\n         |    namespace        : ").append(deployRequest.kubernetesNamespace()).append("\n         |    exposedType      : ").append(deployRequest.flinkRestExposedType()).append("\n         |    serviceAccount   : ").append(deployRequest.serviceAccount()).append("\n         |    flinkImage       : ").append(deployRequest.flinkImage()).append("\n         |    properties       : ").append(JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(deployRequest.properties()).mkString(" ")).append("\n         |-------------------------------------------------------------------------------------------\n         |").toString())).stripMargin());
        Configuration flinkConfig = this.getFlinkK8sConfig(deployRequest);
        FlinkKubeClient kubeClient = FlinkKubeClientFactory.getInstance().fromConfiguration(flinkConfig, "client");
        KubernetesClusterDescriptor clusterDescriptor = null;
        ClusterClient client = null;
        try {
            try {
                Tuple2<KubernetesClusterDescriptor, ClusterSpecification> kubernetesClusterDescriptor = this.getK8sClusterDescriptorAndSpecification(flinkConfig);
                clusterDescriptor = (KubernetesClusterDescriptor)kubernetesClusterDescriptor._1();
                FlinkKubernetesClient kubeClientWrapper = new FlinkKubernetesClient(kubeClient);
                Optional kubeService = kubeClientWrapper.getService(deployRequest.clusterId());
                client = kubeService.isPresent() ? clusterDescriptor.retrieve(deployRequest.clusterId()).getClusterClient() : clusterDescriptor.deploySessionCluster((ClusterSpecification)kubernetesClusterDescriptor._2()).getClusterClient();
                deployResponse = new DeployResponse(client.getWebInterfaceURL(), (String)client.getClusterId(), DeployResponse$.MODULE$.apply$default$3());
            }
            catch (Exception e) {
                Exception x$1 = e;
                String x$2 = DeployResponse$.MODULE$.apply$default$1();
                String x$3 = DeployResponse$.MODULE$.apply$default$2();
                deployResponse = new DeployResponse(x$2, x$3, (Throwable)x$1);
            }
        }
        catch (Throwable throwable) {
            ClusterClient x$4 = client;
            KubernetesClusterDescriptor x$5 = clusterDescriptor;
            FlinkKubeClient x$6 = kubeClient;
            Function1 x$7 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5, x$6}));
            Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5, x$6}), x$7);
            throw throwable;
        }
        ClusterClient x$4 = client;
        KubernetesClusterDescriptor x$5 = clusterDescriptor;
        FlinkKubeClient x$6 = kubeClient;
        Function1 x$7 = Utils$.MODULE$.close$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5, x$6}));
        Utils$.MODULE$.close((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5, x$6}), x$7);
        return deployResponse;
    }

    public ShutDownResponse shutdown(DeployRequest deployRequest) throws Exception {
        ShutDownResponse shutDownResponse;
        KubernetesDeployRequest shutDownRequest = (KubernetesDeployRequest)deployRequest;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(554).append("\n         |--------------------------------------- kubernetes session cluster shutdown ---------------------------------------\n         |    userFlinkHome     : ").append(shutDownRequest.flinkVersion().version()).append("\n         |    namespace         : ").append(shutDownRequest.kubernetesNamespace()).append("\n         |    clusterId         : ").append(shutDownRequest.clusterId()).append("\n         |    execMode          : ").append(shutDownRequest.executionMode().getName()).append("\n         |    flinkImage        : ").append(shutDownRequest.flinkImage()).append("\n         |    exposedType       : ").append(shutDownRequest.flinkRestExposedType().getName()).append("\n         |    kubeConf          : ").append(shutDownRequest.kubeConf()).append("\n         |    serviceAccount    : ").append(shutDownRequest.serviceAccount()).append("\n         |    properties        : ").append(JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(shutDownRequest.properties()).mkString(" ")).append("\n         |-------------------------------------------------------------------------------------------\n         |").toString())).stripMargin());
        Configuration flinkConfig = this.getFlinkK8sConfig(shutDownRequest);
        KubernetesClusterDescriptor clusterDescriptor = this.getK8sClusterDescriptor(flinkConfig);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> clusterDescriptor.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            shutDownResponse = new ShutDownResponse(e);
        } else if (try_ instanceof Success) {
            ShutDownResponse shutDownResponse2;
            Success success = (Success)try_;
            ClusterClient c = (ClusterClient)success.value();
            Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c.shutDownCluster());
            if (try_2 instanceof Success) {
                shutDownResponse2 = new ShutDownResponse(ShutDownResponse$.MODULE$.apply$default$1());
            } else if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                shutDownResponse2 = new ShutDownResponse(e);
            } else {
                throw new MatchError((Object)try_2);
            }
            shutDownResponse = shutDownResponse2;
        } else {
            throw new MatchError((Object)try_);
        }
        return shutDownResponse;
    }

    private Configuration getFlinkK8sConfig(KubernetesDeployRequest deployRequest) {
        return this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.extractConfiguration(deployRequest.flinkVersion().flinkHome(), deployRequest.properties())).safeSet(DeploymentOptions.TARGET, KubernetesDeploymentTarget.SESSION.getName())).safeSet(KubernetesConfigOptions.NAMESPACE, deployRequest.kubernetesNamespace())).safeSet(KubernetesConfigOptions.KUBERNETES_SERVICE_ACCOUNT, deployRequest.serviceAccount())).safeSet(KubernetesConfigOptions.CLUSTER_ID, deployRequest.clusterId())).safeSet(KubernetesConfigOptions.CONTAINER_IMAGE, deployRequest.flinkImage())).safeSet(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE, KubernetesConfigOptions.ServiceExposedType.valueOf((String)deployRequest.flinkRestExposedType().getName()))).safeSet(KubernetesConfigOptions.KUBE_CONFIG_FILE, this.getDefaultKubernetesConf(deployRequest.kubeConf()))).safeSet(DeploymentOptionsInternal.CONF_DIR, new StringBuilder(5).append(deployRequest.flinkVersion().flinkHome()).append("/conf").toString());
    }

    @Override
    public SavepointResponse doTriggerSavepoint(TriggerSavepointRequest request, Configuration flinkConf) {
        this.EnhanceFlinkConfiguration(flinkConf).safeSet(DeploymentOptions.TARGET, ExecutionMode.KUBERNETES_NATIVE_SESSION.getName());
        return KubernetesNativeClientTrait.doTriggerSavepoint$(this, request, flinkConf);
    }

    private KubernetesNativeSessionClient$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
        FlinkClientTrait.$init$(this);
        KubernetesNativeClientTrait.$init$(this);
    }
}

