/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import javax.activation.DataSource;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.resolver.DataSourceBaseResolver;

public class DataSourceCompositeResolver
extends DataSourceBaseResolver {
    private final DataSourceResolver[] dataSourceResolvers;

    public DataSourceCompositeResolver(DataSourceResolver[] dataSourceResolvers) {
        this.dataSourceResolvers = new DataSourceResolver[dataSourceResolvers.length];
        System.arraycopy(dataSourceResolvers, 0, this.dataSourceResolvers, 0, dataSourceResolvers.length);
    }

    public DataSourceCompositeResolver(DataSourceResolver[] dataSourceResolvers, boolean isLenient) {
        super(isLenient);
        this.dataSourceResolvers = new DataSourceResolver[dataSourceResolvers.length];
        System.arraycopy(dataSourceResolvers, 0, this.dataSourceResolvers, 0, dataSourceResolvers.length);
    }

    public DataSourceResolver[] getDataSourceResolvers() {
        DataSourceResolver[] resolvers = new DataSourceResolver[this.dataSourceResolvers.length];
        System.arraycopy(this.dataSourceResolvers, 0, resolvers, 0, this.dataSourceResolvers.length);
        return resolvers;
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        DataSource result = this.resolve(resourceLocation, true);
        if (this.isLenient() || result != null) {
            return result;
        }
        throw new IOException("The following resource was not found : " + resourceLocation);
    }

    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        for (int i = 0; i < this.getDataSourceResolvers().length; ++i) {
            DataSourceResolver dataSourceResolver = this.getDataSourceResolvers()[i];
            DataSource dataSource = dataSourceResolver.resolve(resourceLocation, isLenient);
            if (dataSource == null) continue;
            return dataSource;
        }
        if (isLenient) {
            return null;
        }
        throw new IOException("The following resource was not found : " + resourceLocation);
    }
}

