/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.annotation.AppUpdated;
import org.apache.streampark.console.core.annotation.PermissionAction;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationBackUp;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.enums.AppExistsState;
import org.apache.streampark.console.core.enums.PermissionType;
import org.apache.streampark.console.core.service.AppBuildPipeService;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="FLINK_APPLICATION_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/app"})
public class ApplicationController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationBackUpService backUpService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private AppBuildPipeService appBuildPipeService;

    @Operation(summary="Get application")
    @ApiAccess
    @PostMapping(value={"get"})
    @RequiresPermissions(value={"app:detail"})
    public RestResponse get(Application app) {
        Application application = this.applicationService.getApp(app);
        return RestResponse.success(application);
    }

    @Operation(summary="Create application")
    @ApiAccess
    @PermissionAction(id="#app.teamId", type=PermissionType.TEAM)
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse create(Application app) throws IOException {
        boolean saved = this.applicationService.create(app);
        return RestResponse.success(saved);
    }

    @Operation(summary="Copy application", tags={"FLINK_APPLICATION_OPERATION_TAG"})
    @Parameters(value={@Parameter(name="id", description="copied target app id", in=ParameterIn.QUERY, required=true, example="100000"), @Parameter(name="jobName", description="new application name", in=ParameterIn.QUERY, example="copy-app"), @Parameter(name="args", description="new application args", in=ParameterIn.QUERY)})
    @ApiAccess
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"copy"})
    @RequiresPermissions(value={"app:copy"})
    public RestResponse copy(@Parameter(hidden=true) Application app) throws IOException {
        Long id = this.applicationService.copy(app);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", Long.toString(id));
        return id.equals(0L) ? RestResponse.success(false).data(data) : RestResponse.success(true).data(data);
    }

    @Operation(summary="Update application")
    @AppUpdated
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"app:update"})
    public RestResponse update(Application app) {
        this.applicationService.update(app);
        return RestResponse.success(true);
    }

    @Operation(summary="Get applications dashboard data")
    @PostMapping(value={"dashboard"})
    public RestResponse dashboard(Long teamId) {
        Map<String, Serializable> map = this.applicationService.dashboard(teamId);
        return RestResponse.success(map);
    }

    @Operation(summary="List applications")
    @ApiAccess
    @PostMapping(value={"list"})
    @RequiresPermissions(value={"app:view"})
    public RestResponse list(Application app, RestRequest request) {
        IPage<Application> applicationList = this.applicationService.page(app, request);
        return RestResponse.success(applicationList);
    }

    @Operation(summary="Mapping application")
    @AppUpdated
    @PostMapping(value={"mapping"})
    @RequiresPermissions(value={"app:mapping"})
    public RestResponse mapping(Application app) {
        boolean flag = this.applicationService.mapping(app);
        return RestResponse.success(flag);
    }

    @Operation(summary="Revoke application")
    @AppUpdated
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"revoke"})
    @RequiresPermissions(value={"app:release"})
    public RestResponse revoke(Application app) {
        this.applicationService.revoke(app);
        return RestResponse.success();
    }

    @Operation(summary="Start application", tags={"FLINK_APPLICATION_OPERATION_TAG"})
    @Parameters(value={@Parameter(name="id", description="start app id", in=ParameterIn.QUERY, required=true, example="100000", schema=@Schema(implementation=Long.class)), @Parameter(name="savePointed", description="restored app from the savepoint or latest checkpoint", in=ParameterIn.QUERY, required=true, example="false", schema=@Schema(implementation=boolean.class, defaultValue="false")), @Parameter(name="savePoint", description="savepoint or checkpoint path", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class)), @Parameter(name="allowNonRestored", description="ignore savepoint if cannot be restored", in=ParameterIn.QUERY, required=false, schema=@Schema(implementation=boolean.class, defaultValue="false"))})
    @ApiAccess
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"start"})
    @RequiresPermissions(value={"app:start"})
    public RestResponse start(@Parameter(hidden=true) Application app) {
        try {
            this.applicationService.checkEnv(app);
            this.applicationService.start(app, false);
            return RestResponse.success(true);
        }
        catch (Exception e) {
            return RestResponse.success(false).message(e.getMessage());
        }
    }

    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"check_start"})
    @RequiresPermissions(value={"app:start"})
    public RestResponse checkStart(Application app) {
        AppExistsState stateEnum = this.applicationService.checkStart(app);
        return RestResponse.success(stateEnum.get());
    }

    @Operation(summary="Cancel application", tags={"FLINK_APPLICATION_OPERATION_TAG"})
    @ApiAccess
    @Parameters(value={@Parameter(name="id", description="cancel app id", in=ParameterIn.QUERY, required=true, example="100000", schema=@Schema(implementation=Long.class)), @Parameter(name="savePointed", description="trigger savepoint before taking stopping", in=ParameterIn.QUERY, required=true, schema=@Schema(implementation=boolean.class, defaultValue="false")), @Parameter(name="savePoint", description="savepoint path", in=ParameterIn.QUERY, example="hdfs:///savepoint/100000", schema=@Schema(implementation=String.class)), @Parameter(name="drain", description="send max watermark before canceling", in=ParameterIn.QUERY, required=true, example="false", schema=@Schema(implementation=boolean.class, defaultValue="false"))})
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"cancel"})
    @RequiresPermissions(value={"app:cancel"})
    public RestResponse cancel(@Parameter(hidden=true) Application app) throws Exception {
        this.applicationService.cancel(app);
        return RestResponse.success();
    }

    @Operation(summary="Clean application")
    @AppUpdated
    @ApiAccess
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"clean"})
    @RequiresPermissions(value={"app:clean"})
    public RestResponse clean(Application app) {
        this.applicationService.clean(app);
        return RestResponse.success(true);
    }

    @Operation(summary="Force stop application")
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"forcedStop"})
    @RequiresPermissions(value={"app:cancel"})
    public RestResponse forcedStop(Application app) {
        this.applicationService.forcedStop(app);
        return RestResponse.success();
    }

    @Operation(summary="Get application on yarn proxy address")
    @PostMapping(value={"yarn"})
    public RestResponse yarn() {
        return RestResponse.success(YarnUtils.getRMWebAppProxyURL());
    }

    @Operation(summary="Get application on yarn name")
    @PostMapping(value={"name"})
    public RestResponse yarnName(Application app) {
        String yarnName = this.applicationService.getYarnName(app);
        return RestResponse.success(yarnName);
    }

    @Operation(summary="Check the application exist status")
    @PostMapping(value={"checkName"})
    public RestResponse checkName(Application app) {
        AppExistsState exists = this.applicationService.checkExists(app);
        return RestResponse.success(exists.get());
    }

    @Operation(summary="Get application conf")
    @PostMapping(value={"readConf"})
    public RestResponse readConf(Application app) throws IOException {
        String config = this.applicationService.readConf(app);
        return RestResponse.success(config);
    }

    @Operation(summary="Get application main-class")
    @PostMapping(value={"main"})
    public RestResponse getMain(Application application) {
        String mainClass = this.applicationService.getMain(application);
        return RestResponse.success(mainClass);
    }

    @Operation(summary="List application backups")
    @PostMapping(value={"backups"})
    public RestResponse backups(ApplicationBackUp backUp, RestRequest request) {
        IPage<ApplicationBackUp> backups = this.backUpService.page(backUp, request);
        return RestResponse.success(backups);
    }

    @Operation(summary="List application operation logs")
    @PostMapping(value={"optionlog"})
    public RestResponse optionlog(ApplicationLog applicationLog, RestRequest request) {
        IPage<ApplicationLog> applicationList = this.applicationLogService.page(applicationLog, request);
        return RestResponse.success(applicationList);
    }

    @Operation(summary="Delete application operation log")
    @PermissionAction(id="#applicationLog.appId", type=PermissionType.APP)
    @PostMapping(value={"deleteOperationLog"})
    @RequiresPermissions(value={"app:delete"})
    public RestResponse deleteOperationLog(ApplicationLog applicationLog) {
        Boolean deleted = this.applicationLogService.delete(applicationLog);
        return RestResponse.success(deleted);
    }

    @Operation(summary="Delete application")
    @PermissionAction(id="#app.id", type=PermissionType.APP)
    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"app:delete"})
    public RestResponse delete(Application app) throws InternalException {
        Boolean deleted = this.applicationService.delete(app);
        return RestResponse.success(deleted);
    }

    @Operation(summary="Backup application when deleted")
    @PermissionAction(id="#backUp.appId", type=PermissionType.APP)
    @PostMapping(value={"deletebak"})
    public RestResponse deleteBak(ApplicationBackUp backUp) throws InternalException {
        Boolean deleted = this.backUpService.delete(backUp.getId());
        return RestResponse.success(deleted);
    }

    @Operation(summary="Check the application jar")
    @PostMapping(value={"checkjar"})
    public RestResponse checkjar(String jar) {
        File file = new File(jar);
        try {
            Utils.checkJarFile((URL)file.toURI().toURL());
            return RestResponse.success(true);
        }
        catch (IOException e) {
            return RestResponse.success(file).message(e.getLocalizedMessage());
        }
    }

    @Operation(summary="Upload the application jar")
    @PostMapping(value={"upload"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse upload(MultipartFile file) throws Exception {
        String uploadPath = this.applicationService.upload(file);
        return RestResponse.success(uploadPath);
    }

    @Hidden
    @PostMapping(value={"verifySchema"})
    public RestResponse verifySchema(String path) {
        URI uri = URI.create(path);
        String scheme = uri.getScheme();
        String pathPart = uri.getPath();
        RestResponse restResponse = RestResponse.success(true);
        String error = null;
        if (scheme == null) {
            error = "The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.";
        } else if (pathPart == null) {
            error = "The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.";
        } else if (pathPart.length() == 0 || "/".equals(pathPart)) {
            error = "Cannot use the root directory for checkpoints.";
        }
        if (error != null) {
            restResponse = RestResponse.success(false).message(error);
        }
        return restResponse;
    }

    @Operation(summary="Check the application savepoint path")
    @PostMapping(value={"checkSavepointPath"})
    public RestResponse checkSavepointPath(Application app) throws Exception {
        String error = this.applicationService.checkSavepointPath(app);
        if (error == null) {
            return RestResponse.success(true);
        }
        return RestResponse.success(false).message(error);
    }

    @Operation(summary="Get application on k8s deploy logs")
    @Parameters(value={@Parameter(name="id", description="app id", required=true, example="100000", schema=@Schema(implementation=Long.class)), @Parameter(name="offset", description="number of log lines offset", required=true, example="0", schema=@Schema(implementation=int.class)), @Parameter(name="limit", description="number of log lines loaded at once", required=true, example="100", schema=@Schema(implementation=int.class))})
    @PostMapping(value={"k8sStartLog"})
    public RestResponse k8sStartLog(Long id, Integer offset, Integer limit) throws Exception {
        String resp = this.applicationService.k8sStartLog(id, offset, limit);
        return RestResponse.success(resp);
    }
}

