/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.Template;
import java.util.Map;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.util.FreemarkerUtils;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertHttpCallbackParams;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.service.alert.AlertNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

@Service
@Lazy
public class HttpCallbackAlertNotifyServiceImpl
implements AlertNotifyService {
    private static final Logger log = LoggerFactory.getLogger(HttpCallbackAlertNotifyServiceImpl.class);
    @Autowired
    private RestTemplate alertRestTemplate;
    @Autowired
    private ObjectMapper mapper;

    @Override
    public boolean doAlert(AlertConfigWithParams alertConfig, AlertTemplate alertTemplate) throws AlertException {
        AlertHttpCallbackParams alertHttpCallbackParams = alertConfig.getHttpCallbackParams();
        String requestTemplate = alertHttpCallbackParams.getRequestTemplate();
        if (!StringUtils.hasLength((String)requestTemplate)) {
            return false;
        }
        try {
            Template template = FreemarkerUtils.loadTemplateString(requestTemplate);
            String format = FreemarkerUtils.format(template, alertTemplate);
            Map body = (Map)this.mapper.readValue(format, (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.sendMessage(alertHttpCallbackParams, body);
            return true;
        }
        catch (AlertException alertException) {
            throw alertException;
        }
        catch (Exception e) {
            throw new AlertException("Failed send httpCallback alert", e);
        }
    }

    private Object sendMessage(AlertHttpCallbackParams params, Map<String, Object> body) throws AlertException {
        ResponseEntity response;
        String url = params.getUrl();
        HttpHeaders headers = new HttpHeaders();
        String contentType = params.getContentType();
        MediaType mediaType = MediaType.APPLICATION_JSON;
        if (StringUtils.hasLength((String)contentType)) {
            switch (contentType.toLowerCase()) {
                case "application/x-www-form-urlencoded": {
                    mediaType = MediaType.APPLICATION_FORM_URLENCODED;
                    break;
                }
                case "multipart/form-data": {
                    mediaType = MediaType.MULTIPART_FORM_DATA;
                    break;
                }
            }
        }
        headers.setContentType(mediaType);
        try {
            HttpMethod httpMethod = HttpMethod.POST;
            String method = params.getMethod();
            if (!StringUtils.hasLength((String)method) && HttpMethod.PUT.name().equalsIgnoreCase(method)) {
                httpMethod = HttpMethod.PUT;
            }
            HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
            RequestCallback requestCallback = this.alertRestTemplate.httpEntityCallback((Object)entity, Object.class);
            ResponseExtractor responseExtractor = this.alertRestTemplate.responseEntityExtractor(Object.class);
            response = (ResponseEntity)this.alertRestTemplate.execute(url, httpMethod, requestCallback, responseExtractor, new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to request httpCallback alert,\nurl:{}", (Object)url, (Object)e);
            throw new AlertException(String.format("Failed to request httpCallback alert,\nurl:%s", url), e);
        }
        if (response == null) {
            throw new AlertException(String.format("Failed to request httpCallback alert,\nurl:%s", url));
        }
        return response;
    }
}

