/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public class PartitionTable<K> {
    private final Map<K, Set<ResultPartitionID>> trackedPartitionsPerKey = new ConcurrentHashMap<K, Set<ResultPartitionID>>(8);

    public boolean hasTrackedPartitions(K key) {
        return this.trackedPartitionsPerKey.containsKey(key);
    }

    public void startTrackingPartitions(K key, Collection<ResultPartitionID> newPartitionIds) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(newPartitionIds);
        if (newPartitionIds.isEmpty()) {
            return;
        }
        this.trackedPartitionsPerKey.compute(key, (ignored, partitionIds) -> {
            if (partitionIds == null) {
                partitionIds = new HashSet(8);
            }
            partitionIds.addAll(newPartitionIds);
            return partitionIds;
        });
    }

    public Collection<ResultPartitionID> stopTrackingPartitions(K key) {
        Preconditions.checkNotNull(key);
        Set<ResultPartitionID> storedPartitions = this.trackedPartitionsPerKey.remove(key);
        return storedPartitions == null ? Collections.emptyList() : storedPartitions;
    }

    public void stopTrackingPartitions(K key, Collection<ResultPartitionID> partitionIds) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(partitionIds);
        this.trackedPartitionsPerKey.computeIfPresent(key, (ignored, resultPartitionIDS) -> {
            resultPartitionIDS.removeAll(partitionIds);
            return resultPartitionIDS.isEmpty() ? null : resultPartitionIDS;
        });
    }
}

