/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.fs.LfsOperator$;
import org.apache.streampark.common.util.FileUtils$;
import org.apache.streampark.common.util.HostsUtils$;
import org.apache.streampark.common.util.PropertiesUtils$;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HadoopConfigUtils$ {
    public static final HadoopConfigUtils$ MODULE$;
    private scala.collection.immutable.Map<String, String> kerberosConf;
    private String hadoopUserName;
    private String kerberosDebug;
    private boolean kerberosEnable;
    private String kerberosPrincipal;
    private final String kerberosKeytab;
    private final String kerberosKrb5;
    private final String[] org$apache$streampark$common$util$HadoopConfigUtils$$HADOOP_CLIENT_CONF_FILES;
    private final String[] org$apache$streampark$common$util$HadoopConfigUtils$$HIVE_CLIENT_CONF_FILES;
    private volatile byte bitmap$0;

    static {
        new HadoopConfigUtils$();
    }

    private scala.collection.immutable.Map kerberosConf$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2 = ((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(System.getProperties()).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x$1) {
                        return ((String)x$1._1()).startsWith("security.kerberos");
                    }
                })).toMap(Predef$.MODULE$.$conforms());
                scala.collection.immutable.Map map3 = map2;
                if (map3.nonEmpty()) {
                    map = map3;
                } else {
                    String appHome = SystemPropertyUtils$.MODULE$.get(ConfigConst$.MODULE$.KEY_APP_HOME(), null);
                    File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf/kerberos.yml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appHome})));
                    map = file.exists() && file.isFile() ? PropertiesUtils$.MODULE$.fromYamlFile(file.getAbsolutePath()) : Predef$.MODULE$.Map().empty();
                }
                this.kerberosConf = map;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.kerberosConf;
        }
    }

    private String hadoopUserName$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopUserName = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_HADOOP_USER_NAME());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.hadoopUserName;
        }
    }

    private String kerberosDebug$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.kerberosDebug = (String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_DEBUG(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "false";
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.kerberosDebug;
        }
    }

    private boolean kerberosEnable$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.kerberosEnable = new StringOps(Predef$.MODULE$.augmentString((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_ENABLE(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "false";
                    }
                }))).toBoolean();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.kerberosEnable;
        }
    }

    private String kerberosPrincipal$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.kerberosPrincipal = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_PRINCIPAL(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.kerberosPrincipal;
        }
    }

    private scala.collection.immutable.Map<String, String> kerberosConf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.kerberosConf$lzycompute() : this.kerberosConf;
    }

    public String hadoopUserName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hadoopUserName$lzycompute() : this.hadoopUserName;
    }

    public String kerberosDebug() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.kerberosDebug$lzycompute() : this.kerberosDebug;
    }

    public boolean kerberosEnable() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.kerberosEnable$lzycompute() : this.kerberosEnable;
    }

    public String kerberosPrincipal() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.kerberosPrincipal$lzycompute() : this.kerberosPrincipal;
    }

    public String kerberosKeytab() {
        return this.kerberosKeytab;
    }

    public String kerberosKrb5() {
        return this.kerberosKrb5;
    }

    public String[] org$apache$streampark$common$util$HadoopConfigUtils$$HADOOP_CLIENT_CONF_FILES() {
        return this.org$apache$streampark$common$util$HadoopConfigUtils$$HADOOP_CLIENT_CONF_FILES;
    }

    public String[] org$apache$streampark$common$util$HadoopConfigUtils$$HIVE_CLIENT_CONF_FILES() {
        return this.org$apache$streampark$common$util$HadoopConfigUtils$$HIVE_CLIENT_CONF_FILES;
    }

    public Option<String> getSystemHadoopConfDir() {
        Try try_;
        block4: {
            Some some;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return FileUtils$.MODULE$.getPathFromEnv("HADOOP_CONF_DIR");
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    String p = (String)success.value();
                    some = new Some((Object)p);
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                String p = FileUtils$.MODULE$.resolvePath(FileUtils$.MODULE$.getPathFromEnv("HADOOP_HOME"), "/etc/hadoop");
                some = new Some((Object)p);
            }
            return some;
        }
        throw new MatchError((Object)try_);
    }

    public Optional<String> getSystemHadoopConfDirAsJava() {
        return Optional.ofNullable(this.getSystemHadoopConfDir().orNull(Predef$.MODULE$.$conforms()));
    }

    public Option<String> getSystemHiveConfDir() {
        return Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return FileUtils$.MODULE$.getPathFromEnv("HIVE_CONF_DIR");
            }
        }).toOption();
    }

    public Optional<String> getSystemHiveConfDirAsJava() {
        return Optional.ofNullable(this.getSystemHiveConfDir().orNull(Predef$.MODULE$.$conforms()));
    }

    public void replaceHostWithIP(File configFile) {
        ListMap<String, String> hostsMap;
        if (configFile.exists() && configFile.isFile() && configFile.getName().endsWith(".xml") && (hostsMap = HostsUtils$.MODULE$.getSortSystemHosts()).nonEmpty()) {
            this.org$apache$streampark$common$util$HadoopConfigUtils$$rewriteHostIpMapper(configFile, hostsMap);
        }
    }

    public void batchReplaceHostWithIP(File configDir, String[] filter) {
        if (configDir.isDirectory()) {
            ListMap<String, String> hostsMap = HostsUtils$.MODULE$.getSortSystemHosts();
            if (hostsMap.isEmpty()) {
                return;
            }
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configDir.listFiles()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$2) {
                    return x$2.isFile();
                }
            })).filter((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                private final String[] filter$1;

                public final boolean apply(File e) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.filter$1).contains((Object)e.getName());
                }
                {
                    this.filter$1 = filter$1;
                }
            })).foreach((Function1)new Serializable(hostsMap){
                public static final long serialVersionUID = 0L;
                private final ListMap hostsMap$2;

                public final void apply(File x$3) {
                    HadoopConfigUtils$.MODULE$.org$apache$streampark$common$util$HadoopConfigUtils$$rewriteHostIpMapper(x$3, (ListMap<String, String>)this.hostsMap$2);
                }
                {
                    this.hostsMap$2 = hostsMap$2;
                }
            });
            return;
        }
        this.replaceHostWithIP(configDir);
    }

    public String[] batchReplaceHostWithIP$default$2() {
        return this.org$apache$streampark$common$util$HadoopConfigUtils$$HADOOP_CLIENT_CONF_FILES();
    }

    public void org$apache$streampark$common$util$HadoopConfigUtils$$rewriteHostIpMapper(File configFile, ListMap<String, String> hostsMap) {
        Buffer lines = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(FileUtils.readLines((File)configFile)).map((Function1)new Serializable(hostsMap){
            public static final long serialVersionUID = 0L;
            private final ListMap hostsMap$1;

            public final String apply(String x0$1) {
                String string;
                String string2 = x0$1;
                if (string2.trim().startsWith("<value>")) {
                    Option shot = this.hostsMap$1.find((Function1)new Serializable(this, string2){
                        public static final long serialVersionUID = 0L;
                        private final String x1$1;

                        public final boolean apply(Tuple2<String, String> e) {
                            return this.x1$1.contains((CharSequence)e._1());
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                    ObjectRef li = ObjectRef.create((Object)string2);
                    while (shot.nonEmpty()) {
                        li.elem = ((String)li.elem).replace((CharSequence)((Tuple2)shot.get())._1(), (CharSequence)((Tuple2)shot.get())._2());
                        shot = this.hostsMap$1.find((Function1)new Serializable(this, li){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef li$1;

                            public final boolean apply(Tuple2<String, String> e) {
                                return ((String)this.li$1.elem).contains((CharSequence)e._1());
                            }
                            {
                                this.li$1 = li$1;
                            }
                        });
                    }
                    string = (String)li.elem;
                } else {
                    string = string2;
                }
                return string;
            }
            {
                this.hostsMap$1 = hostsMap$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        FileUtils.writeLines((File)configFile, (Collection)JavaConversions$.MODULE$.bufferAsJavaList(lines));
    }

    public java.util.Map<String, String> readSystemHadoopConf() {
        return (java.util.Map)this.getSystemHadoopConfDir().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, String> apply(String confDir) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])LfsOperator$.MODULE$.listDir(confDir)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File f) {
                        return Predef$.MODULE$.refArrayOps((Object[])HadoopConfigUtils$.MODULE$.org$apache$streampark$common$util$HadoopConfigUtils$$HADOOP_CLIENT_CONF_FILES()).contains((Object)f.getName());
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(File f) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).asJava();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, String> apply() {
                return Collections.emptyMap();
            }
        });
    }

    public java.util.Map<String, String> readSystemHiveConf() {
        return (java.util.Map)this.getSystemHiveConfDir().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, String> apply(String confDir) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])LfsOperator$.MODULE$.listDir(confDir)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File f) {
                        return Predef$.MODULE$.refArrayOps((Object[])HadoopConfigUtils$.MODULE$.org$apache$streampark$common$util$HadoopConfigUtils$$HIVE_CLIENT_CONF_FILES()).contains((Object)f.getName());
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(File f) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms())).asJava();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, String> apply() {
                return Collections.emptyMap();
            }
        });
    }

    private HadoopConfigUtils$() {
        MODULE$ = this;
        this.kerberosKeytab = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KEYTAB(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).trim();
        this.kerberosKrb5 = (String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KRB5_CONF(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.org$apache$streampark$common$util$HadoopConfigUtils$$HADOOP_CLIENT_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "yarn-site.xml"});
        this.org$apache$streampark$common$util$HadoopConfigUtils$$HIVE_CLIENT_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "hive-site.xml"});
    }
}

