/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestHandler;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationRequest;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationResponse;
import org.apache.flink.streaming.api.operators.collect.CollectSinkAddressEvent;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectSinkOperatorCoordinator
implements OperatorCoordinator,
CoordinationRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CollectSinkOperatorCoordinator.class);
    private final int socketTimeout;
    private InetSocketAddress address;
    private Socket socket;
    private DataInputViewStreamWrapper inStream;
    private DataOutputViewStreamWrapper outStream;
    private ExecutorService executorService;

    public CollectSinkOperatorCoordinator(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void start() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("collect-sink-operator-coordinator-executor-thread-pool"));
    }

    public void close() throws Exception {
        this.closeConnection();
        this.executorService.shutdown();
    }

    public void handleEventFromOperator(int subtask, OperatorEvent event) throws Exception {
        Preconditions.checkArgument((boolean)(event instanceof CollectSinkAddressEvent), (Object)"Operator event must be a CollectSinkAddressEvent");
        this.address = ((CollectSinkAddressEvent)event).getAddress();
        LOG.info("Received sink socket server address: " + this.address);
    }

    public CompletableFuture<CoordinationResponse> handleCoordinationRequest(CoordinationRequest request) {
        Preconditions.checkArgument((boolean)(request instanceof CollectCoordinationRequest), (Object)"Coordination request must be a CollectCoordinationRequest");
        CollectCoordinationRequest collectRequest = (CollectCoordinationRequest)request;
        CompletableFuture<CoordinationResponse> responseFuture = new CompletableFuture<CoordinationResponse>();
        if (this.address == null) {
            this.completeWithEmptyResponse(collectRequest, responseFuture);
            return responseFuture;
        }
        this.executorService.submit(() -> this.handleRequestImpl(collectRequest, responseFuture, this.address));
        return responseFuture;
    }

    private void handleRequestImpl(CollectCoordinationRequest request, CompletableFuture<CoordinationResponse> responseFuture, InetSocketAddress sinkAddress) {
        if (sinkAddress == null) {
            this.closeConnection();
            this.completeWithEmptyResponse(request, responseFuture);
            return;
        }
        try {
            if (this.socket == null) {
                this.socket = new Socket();
                this.socket.setSoTimeout(this.socketTimeout);
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.socket.connect(sinkAddress);
                this.inStream = new DataInputViewStreamWrapper(this.socket.getInputStream());
                this.outStream = new DataOutputViewStreamWrapper(this.socket.getOutputStream());
                LOG.info("Sink connection established");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Forwarding request to sink socket server");
            }
            request.serialize((DataOutputView)this.outStream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching serialized result from sink socket server");
            }
            responseFuture.complete(new CollectCoordinationResponse((DataInputView)this.inStream));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Collect sink coordinator encounters an exception", (Throwable)e);
            }
            this.closeConnection();
            this.completeWithEmptyResponse(request, responseFuture);
        }
    }

    private void completeWithEmptyResponse(CollectCoordinationRequest request, CompletableFuture<CoordinationResponse> future) {
        future.complete(new CollectCoordinationResponse(request.getVersion(), -1L, Collections.emptyList()));
    }

    private void closeConnection() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close sink socket server connection", (Throwable)e);
            }
        }
        this.socket = null;
    }

    public void subtaskFailed(int subtask, @Nullable Throwable reason) {
        this.address = null;
    }

    public void subtaskReset(int subtask, long checkpointId) {
    }

    public void subtaskReady(int subtask, OperatorCoordinator.SubtaskGateway gateway) {
    }

    public void checkpointCoordinator(long checkpointId, CompletableFuture<byte[]> result) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.address);
        result.complete(baos.toByteArray());
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void resetToCheckpoint(long checkpointId, @Nullable byte[] checkpointData) throws Exception {
        if (checkpointData == null) {
            this.closeConnection();
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(checkpointData);
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.address = (InetSocketAddress)ois.readObject();
        }
    }

    public static class Provider
    implements OperatorCoordinator.Provider {
        private final OperatorID operatorId;
        private final int socketTimeout;

        public Provider(OperatorID operatorId, int socketTimeout) {
            this.operatorId = operatorId;
            this.socketTimeout = socketTimeout;
        }

        public OperatorID getOperatorId() {
            return this.operatorId;
        }

        public OperatorCoordinator create(OperatorCoordinator.Context context) {
            return new CollectSinkOperatorCoordinator(this.socketTimeout);
        }
    }
}

