/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.dataexplorer.influx.sanitize;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MeasureNameSanitizerTest {

  @Test
  public void testSanitizedMeasure() {
    String originalMeasureName = "test/001";
    String expected = "test_001";
    String sanitizedMeasureName = new MeasureNameSanitizer().sanitize(originalMeasureName);

    Assertions.assertEquals(expected, sanitizedMeasureName);
  }

  @Test
  public void testOriginalMeasure() {
    String originalMeasureName = "test_001";
    String expected = "test_001";
    String sanitizedMeasureName = new MeasureNameSanitizer().sanitize(originalMeasureName);

    Assertions.assertEquals(expected, sanitizedMeasureName);
  }

  @Test
  public void testMultipleCharacters() {
    String originalMeasureName = "t?\"est_001=";
    String expected = "t__est_001_";
    String sanitizedMeasureName = new MeasureNameSanitizer().sanitize(originalMeasureName);

    Assertions.assertEquals(expected, sanitizedMeasureName);
  }
}
