<!--
  ~ Licensed to the Apache Software Foundation (ASF) under one or more
  ~ contributor license agreements.  See the NOTICE file distributed with
  ~ this work for additional information regarding copyright ownership.
  ~ The ASF licenses this file to You under the Apache License, Version 2.0
  ~ (the "License"); you may not use this file except in compliance with
  ~ the License.  You may obtain a copy of the License at
  ~
  ~    http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  ~
  -->

## Telegram Publisher

<p align="center"> 
    <img src="icon.png" width="150px;" class="pe-image-documentation"/>
</p>

***

## Description

Publisher to send notifications to a Telegram channel.

In order to be able to do so, you will have first to:
* Create a Telegram public [channel](https://telegram.org/tour/channels).
> Private channels/groups: also supported.
* Create a Telegram BOT via [@BotFather](https://core.telegram.org/bots#3-how-do-i-create-a-bot) and get an API key.
* Set the bot as [administrator](https://www.wikihow.com/Make-Someone-an-Admin-on-Telegram) in your channel.

***

## Required input

This sink does not have any requirements and works with any incoming event type.

***

## Configuration

Describe the configuration parameters here.

### Bot API Key

The API Key generated by `@BotFather` when you created your bot.

### Channel Name or Chat Id

The handle name of your public channel (e.g. `@channel_name`). 
> For private channels/groups: handle name only available for public channels. Use `chat_id` instead.

### Content

The message to be sent.

## Output

(not applicable for data sinks)
