/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.wsdl20.extensions;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.ComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionSerializer;
import org.apache.woden.wsdl20.extensions.UnknownExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.UnknownExtensionSerializer;
import org.apache.woden.wsdl20.validation.Assertion;
import org.apache.woden.wsdl20.validation.AssertionInfo;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.UnknownAttr;
import org.apache.woden.xml.XMLAttr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRegistry {
    public static final String REGISTRAR_PROPERTY = "org.apache.woden.extensionregistrars";
    private static final String CORE_RESOURCE_BUNDLE = "org.apache.woden.internal.Messages";
    protected Map<Class, Map<QName, ExtensionSerializer>> serializerReg = new Hashtable<Class, Map<QName, ExtensionSerializer>>();
    protected Map<Class, Map<QName, ExtensionDeserializer>> deserializerReg = new Hashtable<Class, Map<QName, ExtensionDeserializer>>();
    protected Map<Class, Map<QName, Class>> extElementReg = new Hashtable<Class, Map<QName, Class>>();
    protected ExtensionSerializer defaultSer = null;
    protected ExtensionDeserializer defaultDeser = null;
    protected Map<Class, Map<QName, Class>> extAttributeReg = new Hashtable<Class, Map<QName, Class>>();
    protected Map<Class, Map<URI, Class<ComponentExtensionContext>>> compExtReg = new Hashtable<Class, Map<URI, Class<ComponentExtensionContext>>>();
    private List<String> fResourceBundleNames = new ArrayList<String>();
    private ErrorReporter errorReporter = null;
    protected Map<String, AssertionInfo> assertionReg = new Hashtable<String, AssertionInfo>();

    public ExtensionRegistry(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.setDefaultSerializer(new UnknownExtensionSerializer());
        this.setDefaultDeserializer(new UnknownExtensionDeserializer());
        this.registerResourceBundle(CORE_RESOURCE_BUNDLE);
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setDefaultSerializer(ExtensionSerializer defaultSer) {
        this.defaultSer = defaultSer;
    }

    public ExtensionSerializer getDefaultSerializer() {
        return this.defaultSer;
    }

    public void setDefaultDeserializer(ExtensionDeserializer defaultDeser) {
        this.defaultDeser = defaultDeser;
    }

    public ExtensionDeserializer getDefaultDeserializer() {
        return this.defaultDeser;
    }

    public void registerSerializer(Class parentType, QName elementType, ExtensionSerializer es) {
        Map<QName, ExtensionSerializer> innerSerializerReg = this.serializerReg.get(parentType);
        if (innerSerializerReg == null) {
            innerSerializerReg = new Hashtable<QName, ExtensionSerializer>();
            this.serializerReg.put(parentType, innerSerializerReg);
        }
        innerSerializerReg.put(elementType, es);
    }

    public void registerDeserializer(Class parentType, QName elementType, ExtensionDeserializer ed) {
        Map<QName, ExtensionDeserializer> innerDeserializerReg = this.deserializerReg.get(parentType);
        if (innerDeserializerReg == null) {
            innerDeserializerReg = new Hashtable<QName, ExtensionDeserializer>();
            this.deserializerReg.put(parentType, innerDeserializerReg);
        }
        innerDeserializerReg.put(elementType, ed);
    }

    public ExtensionSerializer querySerializer(Class parentType, QName elementType) throws WSDLException {
        Map<QName, ExtensionSerializer> innerSerializerReg = this.serializerReg.get(parentType);
        ExtensionSerializer es = null;
        if (innerSerializerReg != null) {
            es = innerSerializerReg.get(elementType);
        }
        if (es == null) {
            es = this.defaultSer;
        }
        if (es == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionSerializer found to serialize a '" + elementType + "' element in the context of a '" + parentType.getName() + "'.");
        }
        return es;
    }

    public ExtensionDeserializer queryDeserializer(Class parentType, QName elementType) throws WSDLException {
        Map<QName, ExtensionDeserializer> innerDeserializerReg = this.deserializerReg.get(parentType);
        ExtensionDeserializer ed = null;
        if (innerDeserializerReg != null) {
            ed = innerDeserializerReg.get(elementType);
        }
        if (ed == null) {
            ed = this.defaultDeser;
        }
        if (ed == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionDeserializer found to deserialize a '" + elementType + "' element in the context of a '" + parentType.getName() + "'.");
        }
        return ed;
    }

    public Class queryExtElementType(Class parentClass, QName elemQN) {
        Map<QName, Class> innerExtensionAttributeReg = this.extAttributeReg.get(parentClass);
        Class elemClass = null;
        if (innerExtensionAttributeReg != null) {
            elemClass = innerExtensionAttributeReg.get(elemQN);
        }
        return elemClass;
    }

    public Set<QName> getAllowableExtensions(Class parentType) {
        Map<QName, ExtensionDeserializer> innerDeserializerReg = this.deserializerReg.get(parentType);
        return innerDeserializerReg != null ? innerDeserializerReg.keySet() : null;
    }

    public void registerExtElementType(Class parentType, QName elementType, Class extensionType) {
        Map<QName, Class> innerExtensionTypeReg = this.extElementReg.get(parentType);
        if (innerExtensionTypeReg == null) {
            innerExtensionTypeReg = new Hashtable<QName, Class>();
            this.extElementReg.put(parentType, innerExtensionTypeReg);
        }
        innerExtensionTypeReg.put(elementType, extensionType);
    }

    public ExtensionElement createExtElement(Class parentType, QName elementType) throws WSDLException {
        Map<QName, Class> innerExtensionTypeReg = this.extElementReg.get(parentType);
        Class extensionType = null;
        if (innerExtensionTypeReg != null) {
            extensionType = innerExtensionTypeReg.get(elementType);
        }
        if (extensionType == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No Java extensionType found to represent a '" + elementType + "' element in the context of a '" + parentType.getName() + "'.");
        }
        if (!ExtensionElement.class.isAssignableFrom(extensionType)) {
            throw new WSDLException("CONFIGURATION_ERROR", "The Java extensionType '" + extensionType.getName() + "' does " + "not implement the ExtensibilityElement " + "interface.");
        }
        try {
            ExtensionElement ee = (ExtensionElement)extensionType.newInstance();
            return ee;
        }
        catch (Exception e) {
            throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating Java extensionType '" + extensionType.getName() + "'.", e);
        }
    }

    public void registerExtAttributeType(Class ownerClass, QName attrQName, Class attrClass) {
        Map<QName, Class> innerExtensionAttributeReg = this.extAttributeReg.get(ownerClass);
        if (innerExtensionAttributeReg == null) {
            innerExtensionAttributeReg = new Hashtable<QName, Class>();
            this.extAttributeReg.put(ownerClass, innerExtensionAttributeReg);
        }
        innerExtensionAttributeReg.put(attrQName, attrClass);
    }

    public Class<XMLAttr> queryExtAttributeType(Class parentClass, QName attrQN) {
        Map<QName, Class> innerExtensionAttributeReg = this.extAttributeReg.get(parentClass);
        Class attrClass = null;
        if (innerExtensionAttributeReg != null) {
            attrClass = innerExtensionAttributeReg.get(attrQN);
        }
        return attrClass;
    }

    public XMLAttr createExtAttribute(Class ownerClass, QName attrQName, XMLElement ownerElement, String attrValue) throws WSDLException {
        Map<QName, Class> innerExtensionAttributeReg = this.extAttributeReg.get(ownerClass);
        Class<XMLAttr> implClass = null;
        XMLAttr attr = null;
        if (innerExtensionAttributeReg != null) {
            implClass = innerExtensionAttributeReg.get(attrQName);
        }
        if (implClass == null) {
            implClass = this.queryExtAttributeType(WSDLElement.class, new QName("http://ws.apache.org/woden", "DefaultAttr"));
            if (implClass == null) {
                implClass = UnknownAttr.class;
            }
        } else if (!XMLAttr.class.isAssignableFrom(implClass)) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL011", new Object[]{attrQName.toString()});
            throw new WSDLException("CONFIGURATION_ERROR", "WSDL011: " + msg);
        }
        try {
            Class[] ctorParms = new Class[]{XMLElement.class, QName.class, String.class, ErrorReporter.class};
            Constructor<XMLAttr> ctor = implClass.getConstructor(ctorParms);
            Object[] ctorParmValues = new Object[]{ownerElement, attrQName, attrValue, this.getErrorReporter()};
            attr = ctor.newInstance(ctorParmValues);
        }
        catch (Exception e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL009", new Object[]{implClass.getName()});
            throw new WSDLException("CONFIGURATION_ERROR", "WSDL009: " + msg, e);
        }
        return attr;
    }

    public void registerComponentExtension(Class parentClass, URI extNamespace, Class compExtCtxClass) {
        if (!ComponentExtensionContext.class.isAssignableFrom(compExtCtxClass)) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL016", new Object[]{compExtCtxClass.getName()});
            throw new IllegalArgumentException(msg);
        }
        Map<URI, Class<ComponentExtensionContext>> innerCompExtReg = this.compExtReg.get(parentClass);
        if (innerCompExtReg == null) {
            innerCompExtReg = new Hashtable<URI, Class<ComponentExtensionContext>>();
            this.compExtReg.put(parentClass, innerCompExtReg);
        }
        innerCompExtReg.put(extNamespace, compExtCtxClass);
    }

    public Class<ComponentExtensionContext> queryComponentExtension(Class parentClass, URI extNamespace) {
        Map<URI, Class<ComponentExtensionContext>> innerCompExtReg = this.compExtReg.get(parentClass);
        Class<ComponentExtensionContext> compExtClass = null;
        if (innerCompExtReg != null) {
            compExtClass = innerCompExtReg.get(extNamespace);
        }
        return compExtClass;
    }

    public URI[] queryComponentExtensionNamespaces(Class parentClass) {
        Map<URI, Class<ComponentExtensionContext>> innerCompExtReg = this.compExtReg.get(parentClass);
        if (innerCompExtReg != null) {
            Set<URI> namespaceKeys = innerCompExtReg.keySet();
            URI[] extNamespaces = new URI[namespaceKeys.size()];
            namespaceKeys.toArray(extNamespaces);
            return extNamespaces;
        }
        return new URI[0];
    }

    public ComponentExtensionContext createComponentExtension(Class parentClass, WSDLComponent parentComp, URI extNamespace) throws WSDLException {
        Class<ComponentExtensionContext> compExtCtxClass = this.queryComponentExtension(parentClass, extNamespace);
        if (compExtCtxClass == null) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL015", new Object[]{extNamespace.toString(), parentClass.getName()});
            throw new WSDLException("CONFIGURATION_ERROR", "WSDL015: " + msg);
        }
        ComponentExtensionContext compExtCtx = null;
        try {
            Class[] ctorParms = new Class[]{WSDLComponent.class, URI.class, ErrorReporter.class};
            Constructor<ComponentExtensionContext> ctor = compExtCtxClass.getConstructor(ctorParms);
            Object[] ctorParmValues = new Object[]{parentComp, extNamespace, this.getErrorReporter()};
            compExtCtx = ctor.newInstance(ctorParmValues);
        }
        catch (Exception e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL009", new Object[]{compExtCtxClass.getName()});
            throw new WSDLException("CONFIGURATION_ERROR", "WSDL009: " + msg, e);
        }
        return compExtCtx;
    }

    public void registerResourceBundle(String resourceBundleName) {
        this.fResourceBundleNames.add(resourceBundleName);
    }

    public String[] queryResourceBundleNames() {
        String[] array = new String[this.fResourceBundleNames.size()];
        this.fResourceBundleNames.toArray(array);
        return array;
    }

    public void registerAssertion(Assertion assertion, Class targetClass) {
        if (assertion == null) {
            String msg = this.errorReporter.getFormattedMessage("WSDL026", new Object[]{"assertion"});
            throw new NullPointerException(msg);
        }
        if (targetClass == null) {
            String msg = this.errorReporter.getFormattedMessage("WSDL026", new Object[]{"targetClass"});
            throw new NullPointerException(msg);
        }
        this.assertionReg.put(assertion.getId(), new AssertionInfo(assertion, targetClass));
    }

    public AssertionInfo queryAssertion(String assertionId) {
        return this.assertionReg.get(assertionId);
    }

    public AssertionInfo[] queryAssertions() {
        Collection<AssertionInfo> values = this.assertionReg.values();
        AssertionInfo[] array = new AssertionInfo[values.size()];
        values.toArray(array);
        return array;
    }
}

