/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.juel;

import com.sun.script.juel.JuelScriptEngineFactory;
import de.odysseus.el.util.SimpleResolver;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class JuelScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private ScriptEngineFactory factory;
    private ExpressionFactory exprFactory;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$javax$script$ScriptContext;
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$com$sun$script$juel$JuelScriptEngine;

    public JuelScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.exprFactory = ExpressionFactory.newInstance();
    }

    public JuelScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public CompiledScript compile(String script) throws ScriptException {
        ValueExpression expr = this.parse(script, this.context);
        return new JuelCompiledScript(expr);
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        ValueExpression expr = this.parse(script, ctx);
        return this.evalExpr(expr, ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        JuelScriptEngine juelScriptEngine = this;
        synchronized (juelScriptEngine) {
            if (this.factory == null) {
                this.factory = new JuelScriptEngineFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private ELContext toELContext(final ScriptContext ctx) {
        Object tmp = ctx.getAttribute("elcontext");
        if (tmp instanceof ELContext) {
            return (ELContext)tmp;
        }
        ctx.setAttribute("context", ctx, 100);
        ctx.setAttribute("out:print", JuelScriptEngine.getPrintMethod(), 100);
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            ctx.setAttribute("lang:import", JuelScriptEngine.getImportMethod(), 100);
        }
        ELContext elContext = new ELContext(){
            ELResolver resolver;
            VariableMapper varMapper;
            FunctionMapper funcMapper;
            {
                this.resolver = JuelScriptEngine.access$200(JuelScriptEngine.this);
                this.varMapper = new ScriptContextVariableMapper(ctx);
                this.funcMapper = new ScriptContextFunctionMapper(ctx);
            }

            public ELResolver getELResolver() {
                return this.resolver;
            }

            public VariableMapper getVariableMapper() {
                return this.varMapper;
            }

            public FunctionMapper getFunctionMapper() {
                return this.funcMapper;
            }
        };
        ctx.setAttribute("elcontext", elContext, 100);
        return elContext;
    }

    private ELResolver makeResolver() {
        CompositeELResolver chain = new CompositeELResolver();
        chain.add((ELResolver)new ArrayELResolver());
        chain.add((ELResolver)new ListELResolver());
        chain.add((ELResolver)new MapELResolver());
        chain.add((ELResolver)new ResourceBundleELResolver());
        chain.add((ELResolver)new BeanELResolver());
        return new SimpleResolver((ELResolver)chain);
    }

    private ValueExpression parse(String script, ScriptContext ctx) throws ScriptException {
        try {
            return this.exprFactory.createValueExpression(this.toELContext(ctx), script, class$java$lang$Object == null ? (class$java$lang$Object = JuelScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (ELException elexp) {
            throw new ScriptException((Exception)((Object)elexp));
        }
    }

    private Object evalExpr(ValueExpression expr, ScriptContext ctx) throws ScriptException {
        try {
            return expr.getValue(this.toELContext(ctx));
        }
        catch (ELException elexp) {
            throw new ScriptException((Exception)((Object)elexp));
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private static Method getPrintMethod() {
        try {
            Class myClass = class$com$sun$script$juel$JuelScriptEngine == null ? (class$com$sun$script$juel$JuelScriptEngine = JuelScriptEngine.class$("com.sun.script.juel.JuelScriptEngine")) : class$com$sun$script$juel$JuelScriptEngine;
            Method method = myClass.getMethod("print", class$java$lang$Object == null ? (class$java$lang$Object = JuelScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
            return method;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void print(Object obj) {
        System.out.print(obj);
    }

    private static Method getImportMethod() {
        try {
            Class myClass = class$com$sun$script$juel$JuelScriptEngine == null ? (class$com$sun$script$juel$JuelScriptEngine = JuelScriptEngine.class$("com.sun.script.juel.JuelScriptEngine")) : class$com$sun$script$juel$JuelScriptEngine;
            Method method = myClass.getMethod("importFunctions", class$javax$script$ScriptContext == null ? (class$javax$script$ScriptContext = JuelScriptEngine.class$("javax.script.ScriptContext")) : class$javax$script$ScriptContext, class$java$lang$String == null ? (class$java$lang$String = JuelScriptEngine.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = JuelScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
            return method;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void importFunctions(ScriptContext ctx, String namespace, Object obj) {
        Method[] methods;
        Class<?> clazz = null;
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        } else if (obj instanceof String) {
            try {
                clazz = Class.forName((String)obj);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ELException((Throwable)cnfe);
            }
        } else {
            throw new ELException("Class or class name is missing");
        }
        Method[] arr$ = methods = clazz.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            String name = namespace + ":" + m.getName();
            ctx.setAttribute(name, m, 100);
        }
    }

    static Object access$000(JuelScriptEngine x0, ValueExpression x1, ScriptContext x2) throws ScriptException {
        return x0.evalExpr(x1, x2);
    }

    static ExpressionFactory access$100(JuelScriptEngine x0) {
        return x0.exprFactory;
    }

    static ELResolver access$200(JuelScriptEngine x0) {
        return x0.makeResolver();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private class ScriptContextFunctionMapper
    extends FunctionMapper {
        private ScriptContext ctx;

        ScriptContextFunctionMapper(ScriptContext ctx) {
            this.ctx = ctx;
        }

        private String getFullName(String prefix, String localName) {
            return prefix + ":" + localName;
        }

        public Method resolveFunction(String prefix, String localName) {
            String fullName = this.getFullName(prefix, localName);
            int scope = this.ctx.getAttributesScope(fullName);
            if (scope != -1) {
                Object tmp = this.ctx.getAttribute(fullName);
                return tmp instanceof Method ? (Method)tmp : null;
            }
            return null;
        }
    }

    private class ScriptContextVariableMapper
    extends VariableMapper {
        private ScriptContext ctx;
        private static final /* synthetic */ Class class$java$lang$Object;

        ScriptContextVariableMapper(ScriptContext ctx) {
            this.ctx = ctx;
        }

        public ValueExpression resolveVariable(String variable) {
            int scope = this.ctx.getAttributesScope(variable);
            if (scope != -1) {
                Object value = this.ctx.getAttribute(variable, scope);
                if (value instanceof ValueExpression) {
                    return (ValueExpression)value;
                }
                return JuelScriptEngine.access$100(JuelScriptEngine.this).createValueExpression(value, class$java$lang$Object == null ? (class$java$lang$Object = ScriptContextVariableMapper.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return null;
        }

        public ValueExpression setVariable(String variable, ValueExpression value) {
            ValueExpression oldValue = this.resolveVariable(variable);
            this.ctx.setAttribute(variable, value, 100);
            return oldValue;
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    private class JuelCompiledScript
    extends CompiledScript {
        private ValueExpression expr;

        JuelCompiledScript(ValueExpression expr) {
            this.expr = expr;
        }

        public ScriptEngine getEngine() {
            return JuelScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JuelScriptEngine.access$000(JuelScriptEngine.this, this.expr, ctx);
        }
    }
}

