/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class NonPositiveInteger
extends BigInteger {
    private static final long serialVersionUID = -8609051961838117600L;
    private BigInteger zero = new BigInteger("0");

    public NonPositiveInteger(byte[] val) {
        super(val);
        this.checkValidity();
    }

    public NonPositiveInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.checkValidity();
    }

    public NonPositiveInteger(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.checkValidity();
    }

    public NonPositiveInteger(int numBits, Random rnd) {
        super(numBits, rnd);
        this.checkValidity();
    }

    public NonPositiveInteger(String val) {
        super(val);
        this.checkValidity();
    }

    public NonPositiveInteger(String val, int radix) {
        super(val, radix);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.zero) > 0) {
            throw new NumberFormatException(":  " + this);
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        return new BigIntegerRep(this.toByteArray());
    }

    protected static class BigIntegerRep
    implements Serializable {
        private static final long serialVersionUID = -3601357690365698517L;
        private byte[] array;

        protected BigIntegerRep(byte[] array) {
            this.array = array;
        }

        protected Object readResolve() throws ObjectStreamException {
            return new NonPositiveInteger(this.array);
        }
    }
}

