/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceBuilderExtension;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployer
implements Deployer {
    protected Map<String, DeploymentFileData> deploymentFileDataMap = new ConcurrentHashMap<String, DeploymentFileData>();
    private List<ServiceBuilderExtension> serviceBuilderExtensions = new CopyOnWriteArrayList<ServiceBuilderExtension>();

    @Override
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        this.deploymentFileDataMap.put(deploymentFileData.getAbsolutePath(), deploymentFileData);
    }

    @Override
    public void undeploy(String fileName) throws DeploymentException {
        this.deploymentFileDataMap.remove(fileName);
    }

    @Override
    public void cleanup() throws DeploymentException {
    }

    public List<ServiceBuilderExtension> getServiceBuilderExtensions() {
        return this.serviceBuilderExtensions;
    }

    public void addServiceBuilderExtensions(ServiceBuilderExtension serviceBuilderExtension) {
        this.serviceBuilderExtensions.add(serviceBuilderExtension);
    }

    protected Map<String, AxisService> executeServiceBuilderExtensions(DeploymentFileData deploymentFileData, ConfigurationContext configurationContext) throws DeploymentException {
        if (this.getServiceBuilderExtensions().size() > 0) {
            for (ServiceBuilderExtension ext : this.getServiceBuilderExtensions()) {
                Map<String, AxisService> serviceMap = ext.buildAxisServices(deploymentFileData);
                if (serviceMap == null || serviceMap.size() <= 0) continue;
                return serviceMap;
            }
        }
        return new HashMap<String, AxisService>();
    }
}

