/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MDDConsumer
implements MessageListener {
    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String dest = MDDConsumer.getProperty("jms_topic", "mdd.MSFT");
        MDDConsumer app = new MDDConsumer();
        app.run(dest);
    }

    public void run(String dest) throws Exception {
        InitialContext ic = this.getInitialContext();
        TopicConnectionFactory confac = (TopicConnectionFactory)ic.lookup("ConnectionFactory");
        TopicConnection connection = confac.createTopicConnection();
        TopicSession session = connection.createTopicSession(false, 1);
        Topic topic = session.createTopic(dest);
        TopicSubscriber topicSubscriber = session.createSubscriber(topic);
        topicSubscriber.setMessageListener((MessageListener)this);
        System.out.println("MDD-Consumer listening for topic : " + topic.getTopicName());
        connection.start();
    }

    public void onMessage(Message message) {
        try {
            System.out.println(" Market data recived for symbol : " + message.getJMSDestination().toString());
        }
        catch (JMSException e) {
            System.out.println("Error : " + e.getMessage());
        }
    }

    private InitialContext getInitialContext() throws NamingException {
        Properties env = new Properties();
        if (System.getProperty("java.naming.provider.url") == null) {
            env.put("java.naming.provider.url", "tcp://localhost:61616");
        }
        if (System.getProperty("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        }
        return new InitialContext(env);
    }
}

