/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.KerberosContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosClientExceptionAction
implements PrivilegedExceptionAction<KerberosContext> {
    private static final String javaVersion = System.getProperty("java.version");
    private static final boolean isJava5Or6 = javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6");
    private static final boolean isOracleJavaVendor = System.getProperty("java.vendor").startsWith("Oracle");
    private static final boolean isIBMJavaVendor = System.getProperty("java.vendor").startsWith("IBM");
    private static final String SUN_JGSS_INQUIRE_TYPE_CLASS = "com.sun.security.jgss.InquireType";
    private static final String SUN_JGSS_EXT_GSSCTX_CLASS = "com.sun.security.jgss.ExtendedGSSContext";
    private static final String IBM_JGSS_INQUIRE_TYPE_CLASS = "com.ibm.security.jgss.InquireType";
    private static final String IBM_JGSS_EXT_GSSCTX_CLASS = "com.ibm.security.jgss.ExtendedGSSContext";
    private Principal clientPrincipal;
    private String serviceName;
    private boolean isUsernameServiceNameForm;

    public KerberosClientExceptionAction(Principal clientPrincipal, String serviceName, boolean isUsernameServiceNameForm) {
        this.clientPrincipal = clientPrincipal;
        this.serviceName = serviceName;
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    @Override
    public KerberosContext run() throws GSSException, WSSecurityException {
        GSSManager gssManager = GSSManager.getInstance();
        Oid kerberos5Oid = new Oid("1.2.840.113554.1.2.2");
        GSSName gssClient = gssManager.createName(this.clientPrincipal.getName(), GSSName.NT_USER_NAME);
        GSSCredential credentials = gssManager.createCredential(gssClient, 0, kerberos5Oid, 1);
        GSSName gssService = gssManager.createName(this.serviceName, this.isUsernameServiceNameForm ? GSSName.NT_USER_NAME : GSSName.NT_HOSTBASED_SERVICE);
        GSSContext secContext = gssManager.createContext(gssService, kerberos5Oid, credentials, 0);
        secContext.requestMutualAuth(false);
        byte[] token = new byte[]{};
        byte[] returnedToken = secContext.initSecContext(token, 0, token.length);
        KerberosContext krbCtx = new KerberosContext();
        krbCtx.setGssContext(secContext);
        krbCtx.setKerberosToken(returnedToken);
        if (!isJava5Or6 && (isOracleJavaVendor || isIBMJavaVendor)) {
            try {
                Class<?> inquireType = Class.forName(isOracleJavaVendor ? SUN_JGSS_INQUIRE_TYPE_CLASS : IBM_JGSS_INQUIRE_TYPE_CLASS);
                Class<?> extendedGSSContext = Class.forName(isOracleJavaVendor ? SUN_JGSS_EXT_GSSCTX_CLASS : IBM_JGSS_EXT_GSSCTX_CLASS);
                Method inquireSecContext = extendedGSSContext.getMethod("inquireSecContext", inquireType);
                Key key = (Key)inquireSecContext.invoke((Object)secContext, Enum.valueOf(inquireType, "KRB5_GET_SESSION_KEY"));
                krbCtx.setSecretKey(key);
            }
            catch (ClassNotFoundException e) {
                throw new WSSecurityException(0, "kerberosServiceTicketError", new Object[0], e);
            }
            catch (NoSuchMethodException e) {
                throw new WSSecurityException(0, "kerberosServiceTicketError", new Object[0], e);
            }
            catch (InvocationTargetException e) {
                throw new WSSecurityException(0, "kerberosServiceTicketError", new Object[0], e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new WSSecurityException(0, "kerberosServiceTicketError", new Object[0], e);
            }
        }
        return krbCtx;
    }
}

