/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HTTPSender
extends AbstractHTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSender.class);

    protected abstract void sendViaGet(MessageContext var1, URL var2, String var3) throws AxisFault;

    protected abstract void sendViaDelete(MessageContext var1, URL var2, String var3) throws AxisFault;

    protected abstract void sendViaPost(MessageContext var1, URL var2, String var3) throws AxisFault;

    protected abstract void sendViaPut(MessageContext var1, URL var2, String var3) throws AxisFault;

    protected abstract void handleResponse(MessageContext var1, Object var2) throws IOException;

    protected abstract void cleanup(MessageContext var1, Object var2);

    public void send(MessageContext msgContext, URL url, String soapActionString) throws IOException {
        String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
        if (httpMethod != null) {
            if ("GET".equalsIgnoreCase(httpMethod)) {
                this.sendViaGet(msgContext, url, soapActionString);
                return;
            }
            if ("DELETE".equalsIgnoreCase(httpMethod)) {
                this.sendViaDelete(msgContext, url, soapActionString);
                return;
            }
            if ("PUT".equalsIgnoreCase(httpMethod)) {
                this.sendViaPut(msgContext, url, soapActionString);
                return;
            }
        }
        this.sendViaPost(msgContext, url, soapActionString);
    }

    protected HTTPStatusCodeFamily getHTTPStatusCodeFamily(int statusCode) {
        switch (statusCode / 100) {
            case 1: {
                return HTTPStatusCodeFamily.INFORMATIONAL;
            }
            case 2: {
                return HTTPStatusCodeFamily.SUCCESSFUL;
            }
            case 3: {
                return HTTPStatusCodeFamily.REDIRECTION;
            }
            case 4: {
                return HTTPStatusCodeFamily.CLIENT_ERROR;
            }
            case 5: {
                return HTTPStatusCodeFamily.SERVER_ERROR;
            }
        }
        return HTTPStatusCodeFamily.OTHER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HTTPStatusCodeFamily {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        OTHER;

    }
}

