/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.TargetFactory;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.mediators.eip.sample.MessageQueue;
import org.apache.synapse.mediators.eip.sample.SamplingThrottleMediator;

public class SamplingThrottleMediatorFactory
extends AbstractMediatorFactory {
    private static final QName SAMPLER_Q = new QName("http://ws.apache.org/ns/synapse", "sampler");
    private static final QName ID_ATTR = new QName("", "id");
    private static final QName RATE_ATTR = new QName("", "rate");
    private static final QName UNIT_TIME_ATTR = new QName("", "unitTime");
    private static final QName MESSAGE_QUEUE_Q = new QName("http://ws.apache.org/ns/synapse", "messageQueue");
    private static final QName CLASS_ATTR = new QName("", "class");

    @Override
    public Mediator createSpecificMediator(OMElement omElement, Properties properties) {
        OMElement targetElem;
        OMAttribute unitTimeAttribute;
        OMAttribute rateAttribute;
        SamplingThrottleMediator samplingThrottleMediator = new SamplingThrottleMediator();
        this.processAuditStatus(samplingThrottleMediator, omElement);
        OMAttribute idAttribute = omElement.getAttribute(ID_ATTR);
        if (idAttribute != null) {
            samplingThrottleMediator.setId(idAttribute.getAttributeValue());
        }
        if ((rateAttribute = omElement.getAttribute(RATE_ATTR)) != null) {
            try {
                samplingThrottleMediator.setSamplingRate(Integer.parseInt(rateAttribute.getAttributeValue()));
            }
            catch (NumberFormatException nfe) {
                this.handleException("Sampling rate has to be an integer value, but found : " + rateAttribute.getAttributeValue());
            }
        }
        if ((unitTimeAttribute = omElement.getAttribute(UNIT_TIME_ATTR)) != null) {
            try {
                samplingThrottleMediator.setUnitTime(Long.parseLong(unitTimeAttribute.getAttributeValue()));
            }
            catch (NumberFormatException nfe) {
                this.handleException("Sampling unitTime has to be a long value in milliseconds, but found : " + rateAttribute.getAttributeValue());
            }
        }
        if ((targetElem = omElement.getFirstChildWithName(TARGET_Q)) != null) {
            Target target = TargetFactory.createTarget(targetElem, properties);
            samplingThrottleMediator.setTarget(target);
        } else {
            this.handleException("Sampler requires a target for the sampling mediation");
        }
        OMElement messageQueueElem = omElement.getFirstChildWithName(MESSAGE_QUEUE_Q);
        if (messageQueueElem != null && messageQueueElem.getAttribute(CLASS_ATTR) != null) {
            String className = messageQueueElem.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> messageQueueImplClass = Class.forName(className);
                Object obj = messageQueueImplClass.newInstance();
                if (obj instanceof MessageQueue) {
                    samplingThrottleMediator.setMessageQueue((MessageQueue)obj);
                } else {
                    this.handleException("Provided message queue class : " + className + " doesn't implement the org.apache.synapse.mediators.eip.sample.MessageQueue interface");
                }
            }
            catch (ClassNotFoundException e) {
                this.handleException("Couldn't find the class specified for the message queue implementation : " + className);
            }
            catch (InstantiationException e) {
                this.handleException("Couldn't instantiate the message queue : " + className);
            }
            catch (IllegalAccessException e) {
                this.handleException("Couldn't instantiate the message queue : " + className);
            }
        }
        return samplingThrottleMediator;
    }

    @Override
    public QName getTagQName() {
        return SAMPLER_Q;
    }
}

