/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;

public class TemplateEndpointSerializer
extends EndpointSerializer {
    private OMNamespace nullNS;

    public TemplateEndpointSerializer() {
        this.fac = OMAbstractFactory.getOMFactory();
        this.nullNS = this.fac.createOMNamespace("", "");
    }

    @Override
    public OMElement serializeEndpoint(Endpoint epr) {
        TemplateEndpoint endpoints = (TemplateEndpoint)epr;
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        if (endpoints.getName() != null) {
            endpointElement.addAttribute(this.fac.createOMAttribute("name", this.nullNS, endpoints.getName()));
        }
        endpointElement.addAttribute(this.fac.createOMAttribute("template", this.nullNS, endpoints.getTemplate()));
        Map<String, String> parameters = endpoints.getParameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getKey().equals("name")) {
                endpointElement.addAttribute(this.fac.createOMAttribute("name", this.nullNS, entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("uri")) {
                endpointElement.addAttribute(this.fac.createOMAttribute("uri", this.nullNS, entry.getValue()));
                continue;
            }
            OMElement paramElement = this.fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "parameter"));
            endpointElement.addChild((OMNode)paramElement);
            paramElement.addAttribute(this.fac.createOMAttribute("name", this.nullNS, entry.getKey()));
            paramElement.addAttribute(this.fac.createOMAttribute("value", this.nullNS, entry.getValue()));
        }
        return endpointElement;
    }
}

