/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.DynamicLoadbalanceFaultHandler;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public class DynamicLoadbalanceEndpoint
extends LoadbalanceEndpoint {
    private static final Log log = LogFactory.getLog(DynamicLoadbalanceEndpoint.class);
    private static final String PORT_MAPPING_PREFIX = "port.mapping.";
    protected boolean sessionAffinity = false;
    protected Dispatcher dispatcher = null;
    protected long sessionTimeout = -1L;
    private AlgorithmContext algorithmContext;
    private LoadBalanceMembershipHandler lbMembershipHandler;

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        if (!this.initialized) {
            SALSessions salSessions;
            super.init(synapseEnvironment);
            if (this.algorithmContext == null) {
                this.algorithmContext = new AlgorithmContext(this.isClusteringEnabled, cc, this.getName());
            }
            if (!(salSessions = SALSessions.getInstance()).isInitialized()) {
                salSessions.initialize(this.isClusteringEnabled, cc);
            }
        }
        log.info((Object)"Dynamic load balance endpoint initialized");
    }

    public void setLoadBalanceMembershipHandler(LoadBalanceMembershipHandler lbMembershipHandler) {
        this.lbMembershipHandler = lbMembershipHandler;
    }

    public LoadBalanceMembershipHandler getLbMembershipHandler() {
        return this.lbMembershipHandler;
    }

    @Override
    public void send(MessageContext synCtx) {
        SessionInformation sessionInformation = null;
        Member currentMember = null;
        this.setCookieHeader(synCtx);
        ConfigurationContext configCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext();
        if (this.lbMembershipHandler.getConfigurationContext() == null) {
            this.lbMembershipHandler.setConfigurationContext(configCtx);
        }
        if (this.isSessionAffinityBasedLB()) {
            sessionInformation = (SessionInformation)synCtx.getProperty("synapse.sal.endpoint.current.sessioninformation");
            currentMember = (Member)synCtx.getProperty("synapse.sal.current.member");
            if (sessionInformation == null && currentMember == null && (sessionInformation = this.dispatcher.getSession(synCtx)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current session id : " + sessionInformation.getId()));
                }
                currentMember = sessionInformation.getMember();
                synCtx.setProperty("synapse.sal.current.member", currentMember);
                synCtx.setProperty("synapse.sal.endpoint.current.sessioninformation", sessionInformation);
            }
        }
        DynamicLoadbalanceFaultHandlerImpl faultHandler = new DynamicLoadbalanceFaultHandlerImpl();
        if (sessionInformation != null && currentMember != null) {
            sessionInformation.updateExpiryTime();
            this.sendToApplicationMember(synCtx, currentMember, faultHandler, false);
        } else {
            currentMember = this.lbMembershipHandler.getNextApplicationMember(this.algorithmContext);
            if (currentMember == null) {
                String msg = "No application members available";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.sendToApplicationMember(synCtx, currentMember, faultHandler, true);
        }
    }

    protected void setCookieHeader(MessageContext synCtx) {
        String cookieHeader = this.extractSessionID(synCtx, "Cookie");
        if (cookieHeader != null) {
            synCtx.setProperty("LB_COOKIE_HEADER", cookieHeader);
        }
    }

    protected String extractSessionID(MessageContext synCtx, String key) {
        if (key != null) {
            Map headerMap = this.getTransportHeaderMap(synCtx);
            if (headerMap != null) {
                Object cookieObj = headerMap.get(key);
                if (cookieObj instanceof String) {
                    return (String)cookieObj;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Couldn't find the " + key + " header to find the session"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the TRANSPORT_HEADERS to find the session");
            }
        }
        return null;
    }

    private Map getTransportHeaderMap(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setSessionAffinity(boolean sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    public boolean isSessionAffinityBasedLB() {
        return this.sessionAffinity;
    }

    protected void sendToApplicationMember(MessageContext synCtx, Member currentMember, DynamicLoadbalanceFaultHandler faultHandler, boolean newSession) {
        HashMap<String, String> memberHosts;
        org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        axis2MsgCtx.removeProperty("REST_URL_POSTFIX");
        String transport = axis2MsgCtx.getTransportIn().getName();
        String address = synCtx.getTo().getAddress();
        int incomingPort = this.extractPort(synCtx, transport);
        EndpointReference to = this.getEndpointReferenceAfterURLRewrite(currentMember, transport, address, incomingPort);
        synCtx.setTo(to);
        faultHandler.setTo(to);
        faultHandler.setCurrentMember(currentMember);
        synCtx.pushFaultHandler(faultHandler);
        if (this.isFailover()) {
            synCtx.getEnvelope().build();
        }
        Endpoint endpoint = this.getEndpoint(to, currentMember, synCtx);
        faultHandler.setCurrentEp(endpoint);
        if (this.isSessionAffinityBasedLB() && newSession) {
            this.prepareEndPointSequence(synCtx, endpoint);
            synCtx.setProperty("synapse.sal.current.member", currentMember);
            synCtx.setProperty("synape.sal.endpoints.dispatcher", this.dispatcher);
            synCtx.setProperty("synapse.sal.first_message_in_session", Boolean.TRUE);
        }
        if ((memberHosts = (HashMap<String, String>)currentMember.getProperties().get("hosts")) == null) {
            memberHosts = new HashMap<String, String>();
            currentMember.getProperties().put("hosts", memberHosts);
        }
        memberHosts.put(this.extractHost(synCtx), "true");
        try {
            endpoint.send(synCtx);
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().contains("io reactor shutdown")) {
                log.fatal((Object)"System cannot continue normal operation. Restarting", (Throwable)e);
                System.exit(121);
            }
            throw new SynapseException(e);
        }
    }

    private void prepareEndPointSequence(MessageContext synCtx, Endpoint endpoint) {
        ArrayList<DynamicLoadbalanceEndpoint> endpointList;
        Object o = synCtx.getProperty("synapse.sal.endpoint.list");
        if (o instanceof List) {
            endpointList = (ArrayList<DynamicLoadbalanceEndpoint>)o;
            endpointList.add(this);
        } else {
            endpointList = new ArrayList<DynamicLoadbalanceEndpoint>();
            endpointList.add(this);
            synCtx.setProperty("synapse.sal.endpoint.list", endpointList);
        }
        if (!(endpoint instanceof DynamicLoadbalanceEndpoint)) {
            endpointList.add((DynamicLoadbalanceEndpoint)endpoint);
            if (this.dispatcher.isServerInitiatedSession()) {
                this.dispatcher.removeSessionID(synCtx);
            }
        }
    }

    private EndpointReference getEndpointReferenceAfterURLRewrite(Member currentMember, String transport, String address, int incomingPort) {
        if ("http".equals(transport) || "https".equals(transport)) {
            Properties memberProperties;
            String mappedPort;
            if (address.startsWith("http://") || address.startsWith("https://")) {
                try {
                    address = new URL(address).getPath();
                }
                catch (MalformedURLException e) {
                    String msg = "URL " + address + " is malformed";
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException(msg, e);
                }
            }
            int port = (mappedPort = (memberProperties = currentMember.getProperties()).getProperty(PORT_MAPPING_PREFIX + incomingPort)) != null ? Integer.parseInt(mappedPort) : ("http".equals(transport) ? currentMember.getHttpPort() : currentMember.getHttpsPort());
            return new EndpointReference(transport + "://" + currentMember.getHostName() + ":" + port + address);
        }
        String msg = "Cannot load balance for non-HTTP/S transport " + transport;
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private Endpoint getEndpoint(EndpointReference to, Member member, MessageContext synCtx) {
        AddressEndpoint endpoint = new AddressEndpoint();
        endpoint.setEnableMBeanStats(false);
        endpoint.setName("DLB:" + member.getHostName() + ":" + member.getPort() + ":" + UUID.randomUUID());
        EndpointDefinition definition = new EndpointDefinition();
        definition.setSuspendMaximumDuration(10000L);
        definition.setReplicationDisabled(true);
        definition.setAddress(to.getAddress());
        endpoint.setDefinition(definition);
        endpoint.init((SynapseEnvironment)((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext().getAxisConfiguration().getParameterValue("synapse.env"));
        return endpoint;
    }

    private String extractHost(MessageContext synCtx) {
        Object hostObj;
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map headerMap = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String hostName = null;
        if (headerMap != null && (hostName = (String)(hostObj = headerMap.get("Host"))).contains(":")) {
            hostName = hostName.substring(0, hostName.indexOf(":"));
        }
        return hostName;
    }

    private int extractPort(MessageContext synCtx, String transport) {
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map headerMap = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        int port = -1;
        if (headerMap != null) {
            String hostHeader = (String)headerMap.get("Host");
            int index = hostHeader.indexOf(58);
            if (index != -1) {
                port = Integer.parseInt(hostHeader.trim().substring(index + 1));
            } else if ("http".equals(transport)) {
                port = 80;
            } else if ("https".equals(transport)) {
                port = 443;
            }
        }
        return port;
    }

    private class DynamicLoadbalanceFaultHandlerImpl
    extends DynamicLoadbalanceFaultHandler {
        private EndpointReference to;
        private Member currentMember;
        private Endpoint currentEp;

        @Override
        public void setCurrentMember(Member currentMember) {
            this.currentMember = currentMember;
        }

        @Override
        public void setTo(EndpointReference to) {
            this.to = to;
        }

        private DynamicLoadbalanceFaultHandlerImpl() {
        }

        @Override
        public void onFault(MessageContext synCtx) {
            Set pros;
            if (this.currentEp != null) {
                this.currentEp.destroy();
            }
            if (this.currentMember == null) {
                return;
            }
            Stack<FaultHandler> faultStack = synCtx.getFaultStack();
            if (!faultStack.empty()) {
                faultStack.pop();
            }
            this.currentMember = DynamicLoadbalanceEndpoint.this.lbMembershipHandler.getNextApplicationMember(DynamicLoadbalanceEndpoint.this.algorithmContext);
            if (this.currentMember == null) {
                String msg = "No application members available";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            synCtx.setTo(this.to);
            if (DynamicLoadbalanceEndpoint.this.isSessionAffinityBasedLB() && (pros = synCtx.getPropertyKeySet()) != null) {
                pros.remove("synapse.sal.endpoint.current.sessioninformation");
            }
            DynamicLoadbalanceEndpoint.this.sendToApplicationMember(synCtx, this.currentMember, this, true);
        }

        @Override
        public void setCurrentEp(Endpoint currentEp) {
            this.currentEp = currentEp;
        }
    }
}

