/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.algorithms;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.util.Replicator;

public class AlgorithmContext {
    private static final Log log = LogFactory.getLog(AlgorithmContext.class);
    private static final String KEY_PREFIX = "synapse.endpoint.lb.algorithm.";
    private static final String CURRENT_EPR = ".current_epr";
    private ConfigurationContext cfgCtx;
    private boolean isClusteringEnabled = false;
    private String CURRENT_EPR_PROP_KEY;
    private String PROPERTY_KEY_PREFIX;
    private int currentEPR = 0;
    private Map<String, Object> localProperties;

    public AlgorithmContext(boolean clusteringEnabled, ConfigurationContext cfgCtx, String endpointName) {
        this.cfgCtx = cfgCtx;
        this.isClusteringEnabled = clusteringEnabled;
        if (!clusteringEnabled) {
            this.localProperties = new HashMap<String, Object>();
        } else {
            this.PROPERTY_KEY_PREFIX = KEY_PREFIX + endpointName;
            this.CURRENT_EPR_PROP_KEY = this.PROPERTY_KEY_PREFIX + CURRENT_EPR;
        }
    }

    public int getCurrentEndpointIndex() {
        if (this.isClusteringEnabled) {
            Object value = this.cfgCtx.getPropertyNonReplicable(this.CURRENT_EPR_PROP_KEY);
            if (value == null) {
                return 0;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
        } else {
            return this.currentEPR;
        }
        return 0;
    }

    public void setCurrentEndpointIndex(int currentEPR) {
        this.currentEPR = currentEPR;
        this.cfgCtx.setNonReplicableProperty(this.CURRENT_EPR_PROP_KEY, (Object)currentEPR);
    }

    public ConfigurationContext getConfigurationContext() {
        return this.cfgCtx;
    }

    public Object getProperty(String key) {
        if (this.isClusteringEnabled) {
            return this.cfgCtx.getPropertyNonReplicable(this.PROPERTY_KEY_PREFIX + key);
        }
        return this.localProperties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (key != null && value != null) {
            if (this.isClusteringEnabled) {
                Replicator.setAndReplicateState(this.PROPERTY_KEY_PREFIX + key, value, this.cfgCtx);
            } else {
                this.localProperties.put(key, value);
            }
        }
    }
}

