/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.POXUtils;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class FaultMediator
extends AbstractMediator {
    public static final String WSA_ACTION = "Action";
    public static final int SOAP11 = 1;
    public static final int SOAP12 = 2;
    public static final int POX = 3;
    private int soapVersion;
    private boolean markAsResponse = true;
    private boolean serializeResponse = false;
    private QName faultCodeValue = null;
    private SynapseXPath faultCodeExpr = null;
    private String faultReasonValue = null;
    private SynapseXPath faultReasonExpr = null;
    private URI faultNode = null;
    private URI faultRole = null;
    private String faultDetail = null;
    private SynapseXPath faultDetailExpr = null;
    private final List<OMElement> faultDetailElements = new ArrayList<OMElement>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Fault mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        switch (this.soapVersion) {
            case 1: {
                this.makeSOAPFault(synCtx, 1, synLog);
                break;
            }
            case 2: {
                this.makeSOAPFault(synCtx, 2, synLog);
                break;
            }
            case 3: {
                this.makePOXFault(synCtx, synLog);
                break;
            }
            default: {
                if (synCtx.isDoingPOX() || synCtx.isDoingGET()) {
                    this.makePOXFault(synCtx, synLog);
                    break;
                }
                SOAPEnvelope envelop = synCtx.getEnvelope();
                if (envelop != null) {
                    if ("http://www.w3.org/2003/05/soap-envelope".equals(envelop.getNamespace().getNamespaceURI())) {
                        this.makeSOAPFault(synCtx, 2, synLog);
                        break;
                    }
                    this.makeSOAPFault(synCtx, 1, synLog);
                    break;
                }
                this.makeSOAPFault(synCtx, 1, synLog);
            }
        }
        if (this.markAsResponse) {
            synCtx.setResponse(true);
            synCtx.setTo(synCtx.getReplyTo());
        }
        return true;
    }

    private void makePOXFault(MessageContext synCtx, SynapseLog synLog) {
        OMFactory fac = synCtx.getEnvelope().getOMFactory();
        OMElement faultPayload = fac.createOMElement(new QName("Exception"));
        if (this.faultDetail != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting the fault detail : " + this.faultDetail + " as the POX Fault");
            }
            faultPayload.setText(this.faultDetail);
        } else if (this.faultDetailExpr != null) {
            String faultDetail = this.faultDetailExpr.stringValueOf(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting the fault detail : " + faultDetail + " as the POX Fault");
            }
            faultPayload.setText(faultDetail);
        } else if (this.faultReasonValue != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting the fault reason : " + this.faultReasonValue + " as the POX Fault");
            }
            faultPayload.setText(this.faultReasonValue);
        } else if (this.faultReasonExpr != null) {
            String faultReason = this.faultReasonExpr.stringValueOf(synCtx);
            faultPayload.setText(faultReason);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting the fault reason : " + faultReason + " as the POX Fault");
            }
        }
        SOAPBody body = synCtx.getEnvelope().getBody();
        if (body != null) {
            if (body.getFirstElement() != null) {
                body.getFirstElement().detach();
            }
            synCtx.setFaultResponse(true);
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProcessingFault(true);
            if (synLog.isTraceOrDebugEnabled()) {
                String msg = "Original SOAP Message : " + synCtx.getEnvelope().toString() + "POXFault Message created : " + faultPayload.toString();
                synLog.traceTrace(msg);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)msg);
                }
            }
            body.addChild((OMNode)faultPayload);
        }
    }

    private void makeSOAPFault(MessageContext synCtx, int soapVersion, SynapseLog synLog) {
        SOAPHeader soapHeader;
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Creating a SOAP " + (soapVersion == 1 ? "1.1" : "1.2") + " fault");
        }
        SOAPFactory factory = soapVersion == 1 ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        OMDocument soapFaultDocument = factory.createOMDocument();
        SOAPEnvelope faultEnvelope = factory.getDefaultFaultEnvelope();
        soapFaultDocument.addChild((OMNode)faultEnvelope);
        SOAPFault fault = faultEnvelope.getBody().getFault();
        if (fault == null) {
            fault = factory.createSOAPFault();
        }
        this.setFaultCode(synCtx, factory, fault, soapVersion);
        this.setFaultReason(synCtx, factory, fault, soapVersion);
        this.setFaultNode(factory, fault);
        this.setFaultRole(factory, fault);
        this.setFaultDetail(synCtx, factory, fault);
        if (synCtx.getEnvelope() != null && (soapHeader = synCtx.getEnvelope().getHeader()) != null) {
            Iterator iter = soapHeader.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                iter.remove();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock header = (SOAPHeaderBlock)o;
                    faultEnvelope.getHeader().addChild((OMNode)header);
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                faultEnvelope.getHeader().addChild((OMNode)((OMElement)o));
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            String msg = "Original SOAP Message : " + synCtx.getEnvelope().toString() + "Fault Message created : " + faultEnvelope.toString();
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace(msg);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)msg);
            }
        }
        try {
            synCtx.setEnvelope(faultEnvelope);
        }
        catch (AxisFault af) {
            this.handleException("Error replacing current SOAP envelope with the fault envelope", (Exception)((Object)af), synCtx);
        }
        if (synCtx.getFaultTo() != null) {
            synCtx.setTo(synCtx.getFaultTo());
        } else if (synCtx.getReplyTo() != null) {
            synCtx.setTo(synCtx.getReplyTo());
        } else {
            synCtx.setTo(null);
        }
        if (synCtx.getMessageID() != null) {
            RelatesTo relatesTo = new RelatesTo(synCtx.getMessageID());
            synCtx.setRelatesTo(new RelatesTo[]{relatesTo});
        }
        synLog.traceOrDebug("End : Fault mediator");
    }

    private void setFaultCode(MessageContext synCtx, SOAPFactory factory, SOAPFault fault, int soapVersion) {
        QName fault_code = null;
        if (this.faultCodeValue == null && this.faultCodeExpr == null) {
            this.handleException("A valid fault code QName value or expression is required", synCtx);
        } else if (this.faultCodeValue != null) {
            fault_code = this.faultCodeValue;
        } else {
            String codeStr = this.faultCodeExpr.stringValueOf(synCtx);
            fault_code = new QName(fault.getNamespace().getNamespaceURI(), codeStr);
        }
        SOAPFaultCode code = factory.createSOAPFaultCode();
        switch (soapVersion) {
            case 1: {
                code.setText(fault_code);
                break;
            }
            case 2: {
                SOAPFaultValue value = factory.createSOAPFaultValue(code);
                value.setText(fault_code);
            }
        }
        fault.setCode(code);
    }

    private void setFaultReason(MessageContext synCtx, SOAPFactory factory, SOAPFault fault, int soapVersion) {
        String reasonString = null;
        if (this.faultReasonValue == null && this.faultReasonExpr == null) {
            this.handleException("A valid fault reason value or expression is required", synCtx);
        } else {
            reasonString = this.faultReasonValue != null ? this.faultReasonValue : this.faultReasonExpr.stringValueOf(synCtx);
        }
        SOAPFaultReason reason = factory.createSOAPFaultReason();
        switch (soapVersion) {
            case 1: {
                reason.setText(reasonString);
                break;
            }
            case 2: {
                SOAPFaultText text = factory.createSOAPFaultText();
                text.setText(reasonString);
                text.setLang("en");
                reason.addSOAPText(text);
            }
        }
        fault.setReason(reason);
    }

    private void setFaultNode(SOAPFactory factory, SOAPFault fault) {
        if (this.faultNode != null) {
            SOAPFaultNode soapfaultNode = factory.createSOAPFaultNode();
            soapfaultNode.setFaultNodeValue(this.faultNode.toString());
            fault.setNode(soapfaultNode);
        }
    }

    private void setFaultRole(SOAPFactory factory, SOAPFault fault) {
        if (this.faultRole != null) {
            SOAPFaultRole soapFaultRole = factory.createSOAPFaultRole();
            soapFaultRole.setRoleValue(this.faultRole.toString());
            fault.setRole(soapFaultRole);
        }
    }

    private void setFaultDetail(MessageContext synCtx, SOAPFactory factory, SOAPFault fault) {
        if (this.faultDetail != null) {
            SOAPFaultDetail soapFaultDetail = factory.createSOAPFaultDetail();
            soapFaultDetail.setText(this.faultDetail);
            fault.setDetail(soapFaultDetail);
        } else if (this.faultDetailExpr != null) {
            SOAPFaultDetail soapFaultDetail = factory.createSOAPFaultDetail();
            Object result = null;
            try {
                result = this.faultDetailExpr.evaluate(synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", e);
            }
            if (result instanceof List) {
                List list = (List)result;
                for (Object obj : list) {
                    if (!(obj instanceof OMNode)) continue;
                    soapFaultDetail.addChild((OMNode)obj);
                }
            } else {
                OMElement om = POXUtils.getOMFromXML(this.faultDetailExpr.stringValueOf(synCtx));
                if (om != null) {
                    soapFaultDetail.addChild((OMNode)om);
                }
            }
            fault.setDetail(soapFaultDetail);
        } else if (!this.faultDetailElements.isEmpty()) {
            SOAPFaultDetail soapFaultDetail = factory.createSOAPFaultDetail();
            for (OMElement faultDetailElement : this.faultDetailElements) {
                soapFaultDetail.addChild((OMNode)faultDetailElement.cloneOMElement());
            }
            fault.setDetail(soapFaultDetail);
        } else if (fault.getDetail() != null) {
            fault.getDetail().detach();
        }
    }

    public int getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(int soapVersion) {
        this.soapVersion = soapVersion;
    }

    public boolean isMarkAsResponse() {
        return this.markAsResponse;
    }

    public void setMarkAsResponse(boolean markAsResponse) {
        this.markAsResponse = markAsResponse;
    }

    public boolean isSerializeResponse() {
        return this.serializeResponse;
    }

    public void setSerializeResponse(boolean serializeResponse) {
        this.serializeResponse = serializeResponse;
    }

    public QName getFaultCodeValue() {
        return this.faultCodeValue;
    }

    public void setFaultCodeValue(QName faultCodeValue) {
        if (this.soapVersion == 1) {
            this.faultCodeValue = faultCodeValue;
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(faultCodeValue.getNamespaceURI()) && ("DataEncodingUnknown".equals(faultCodeValue.getLocalPart()) || "MustUnderstand".equals(faultCodeValue.getLocalPart()) || "Receiver".equals(faultCodeValue.getLocalPart()) || "Sender".equals(faultCodeValue.getLocalPart()) || "VersionMismatch".equals(faultCodeValue.getLocalPart()))) {
            this.faultCodeValue = faultCodeValue;
        } else {
            this.handleException("Invalid Fault code value for a SOAP 1.2 fault : " + faultCodeValue);
        }
    }

    public SynapseXPath getFaultCodeExpr() {
        return this.faultCodeExpr;
    }

    public void setFaultCodeExpr(SynapseXPath faultCodeExpr) {
        this.faultCodeExpr = faultCodeExpr;
    }

    public String getFaultReasonValue() {
        return this.faultReasonValue;
    }

    public void setFaultReasonValue(String faultReasonValue) {
        this.faultReasonValue = faultReasonValue;
    }

    public SynapseXPath getFaultReasonExpr() {
        return this.faultReasonExpr;
    }

    public void setFaultReasonExpr(SynapseXPath faultReasonExpr) {
        this.faultReasonExpr = faultReasonExpr;
    }

    public URI getFaultNode() {
        return this.faultNode;
    }

    public void setFaultNode(URI faultNode) {
        if (this.soapVersion == 1) {
            this.handleException("A fault node does not apply to a SOAP 1.1 fault");
        }
        this.faultNode = faultNode;
    }

    public URI getFaultRole() {
        return this.faultRole;
    }

    public void setFaultRole(URI faultRole) {
        this.faultRole = faultRole;
    }

    public String getFaultDetail() {
        return this.faultDetail;
    }

    public void setFaultDetail(String faultDetail) {
        this.faultDetail = faultDetail;
    }

    public SynapseXPath getFaultDetailExpr() {
        return this.faultDetailExpr;
    }

    public void setFaultDetailExpr(SynapseXPath faultDetailExpr) {
        this.faultDetailExpr = faultDetailExpr;
    }

    public List<OMElement> getFaultDetailElements() {
        return this.faultDetailElements;
    }

    public void addFaultDetailElement(OMElement element) {
        this.faultDetailElements.add(element);
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Throwable e) {
        this.log.error((Object)msg, e);
        throw new SynapseException(msg, e);
    }
}

