/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2BlockingClient;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class ForwardingJob
implements StatefulJob {
    private static final Log log = LogFactory.getLog(ForwardingJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jdm = jobExecutionContext.getMergedJobDataMap();
        MessageStore messageStore = (MessageStore)jdm.get((Object)"message.store");
        Map parameters = (Map)jdm.get((Object)"parameters");
        Axis2BlockingClient sender = (Axis2BlockingClient)jdm.get((Object)"blocking.sender");
        ScheduledMessageForwardingProcessor processor = (ScheduledMessageForwardingProcessor)jdm.get((Object)"processor.instance");
        int maxDeliverAttempts = -1;
        boolean isMaxDeliverAttemptDropEnabled = false;
        String mdaParam = null;
        if (parameters != null) {
            mdaParam = (String)parameters.get("max.deliver.attempts");
        }
        if (mdaParam != null && (maxDeliverAttempts = Integer.parseInt(mdaParam)) == 0) {
            processor.deactivate();
        }
        if (maxDeliverAttempts > 0 && parameters.get("max.deliver.drop") != null && parameters.get("max.deliver.drop").toString().equalsIgnoreCase("true")) {
            isMaxDeliverAttemptDropEnabled = true;
        }
        if (!processor.isActive() || messageStore == null) {
            return;
        }
        boolean errorStop = false;
        while (!errorStop) {
            MessageContext messageContext = messageStore.peek();
            if (messageContext != null) {
                String targetEp;
                AxisConfiguration configuration;
                String myServerName;
                String serverName = (String)messageContext.getProperty("SynapseConfig.ServerName");
                if (serverName != null && messageContext instanceof Axis2MessageContext && !serverName.equals(myServerName = ForwardingJob.getAxis2ParameterValue(configuration = ((Axis2MessageContext)messageContext).getAxis2MessageContext().getConfigurationContext().getAxisConfiguration(), "SynapseConfig.ServerName"))) {
                    return;
                }
                Set proSet = messageContext.getPropertyKeySet();
                if (proSet != null && proSet.contains("blocking.client.error")) {
                    proSet.remove("blocking.client.error");
                }
                if ((targetEp = (String)messageContext.getProperty("target.endpoint")) != null) {
                    Endpoint ep = messageContext.getEndpoint(targetEp);
                    if (!ep.getContext().readyToSend()) {
                        return;
                    }
                    if (ep != null && ((AbstractEndpoint)ep).isLeafEndpoint()) {
                        try {
                            Mediator mediator;
                            String seq;
                            MessageContext outCtx = sender.send(ep, messageContext);
                            if (outCtx != null && "true".equals(outCtx.getProperty("blocking.client.error"))) {
                                if (maxDeliverAttempts > 0) {
                                    processor.incrementSendAttemptCount();
                                }
                                if (parameters != null && parameters.get("message.processor.fault.sequence") != null) {
                                    seq = (String)parameters.get("message.processor.fault.sequence");
                                    mediator = outCtx.getSequence(seq);
                                    if (mediator != null) {
                                        mediator.mediate(outCtx);
                                    } else {
                                        log.warn((Object)("Can't Send the fault Message , Sequence " + seq + " Does not Exist"));
                                    }
                                }
                                if (maxDeliverAttempts > 0 && processor.getSendAttemptCount() >= maxDeliverAttempts) {
                                    this.deactivate(processor, messageContext, parameters);
                                }
                                errorStop = true;
                                continue;
                            }
                            if (outCtx == null) {
                                messageStore.poll();
                                processor.resetSentAttemptCount();
                                continue;
                            }
                            if (parameters != null && parameters.get("message.processor.reply.sequence") != null && outCtx != null) {
                                seq = (String)parameters.get("message.processor.reply.sequence");
                                mediator = outCtx.getSequence(seq);
                                if (mediator != null) {
                                    mediator.mediate(outCtx);
                                } else {
                                    log.warn((Object)("Can't Send the Out Message , Sequence " + seq + " Does not Exist"));
                                }
                            }
                            processor.resetSentAttemptCount();
                            messageStore.poll();
                        }
                        catch (Exception e) {
                            if (maxDeliverAttempts > 0) {
                                processor.incrementSendAttemptCount();
                                if (processor.getSendAttemptCount() >= maxDeliverAttempts) {
                                    if (isMaxDeliverAttemptDropEnabled) {
                                        processor.resetSentAttemptCount();
                                        messageStore.poll();
                                    } else {
                                        this.deactivate(processor, messageContext, parameters);
                                    }
                                }
                            }
                            errorStop = true;
                            log.error((Object)"Error Forwarding Message ", (Throwable)e);
                        }
                        continue;
                    }
                    String logMsg = ep == null ? "Endpoint named " + targetEp + " not found.Hence removing the message form store" : "Unsupported endpoint type. Only address/wsdl/default endpoint types supported";
                    log.warn((Object)logMsg);
                    messageStore.poll();
                    continue;
                }
                log.warn((Object)"Property target.endpoint not found in the message context , Hence removing the message ");
                messageStore.poll();
                continue;
            }
            errorStop = true;
        }
    }

    private static String getAxis2ParameterValue(AxisConfiguration axisConfiguration, String paramKey) {
        Parameter parameter = axisConfiguration.getParameter(paramKey);
        if (parameter == null) {
            return null;
        }
        Object value = parameter.getValue();
        if (value != null && value instanceof String) {
            return (String)parameter.getValue();
        }
        return null;
    }

    private void deactivate(ScheduledMessageForwardingProcessor processor, MessageContext msgContext, Map<String, Object> parameters) {
        processor.deactivate();
        if (parameters != null && parameters.get("message.processor.deactivate.sequence") != null && msgContext != null) {
            String seq = (String)parameters.get("message.processor.deactivate.sequence");
            Mediator mediator = msgContext.getSequence(seq);
            if (mediator != null) {
                mediator.mediate(msgContext);
            } else {
                log.warn((Object)("Deactivate sequence: " + seq + " does not exist"));
            }
        }
    }
}

