/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2BlockingClient;
import org.apache.synapse.message.processors.ScheduledMessageProcessor;
import org.apache.synapse.message.processors.forward.ForwardingJob;
import org.apache.synapse.message.processors.forward.MessageForwardingProcessorView;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ScheduledMessageForwardingProcessor
extends ScheduledMessageProcessor {
    public static final String BLOCKING_SENDER = "blocking.sender";
    private Axis2BlockingClient sender = null;
    private volatile AtomicBoolean active = new AtomicBoolean(true);
    private volatile AtomicInteger sendAttempts = new AtomicInteger(0);
    private MessageForwardingProcessorView view;

    @Override
    public void init(SynapseEnvironment se) {
        super.init(se);
        this.view = new MessageForwardingProcessorView(se.getSynapseConfiguration().getMessageStore(this.messageStore), this.getSender(), this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "Message Forwarding Processor view", this.getName());
    }

    @Override
    protected JobBuilder getJobBuilder() {
        return JobBuilder.newJob(ForwardingJob.class).withIdentity(this.name + "-forward job", "synapse.message.processor.quartz");
    }

    @Override
    protected JobDataMap getJobDataMap() {
        JobDataMap jdm = new JobDataMap();
        jdm.put(BLOCKING_SENDER, (Object)this.getSender());
        jdm.put("processor.instance", (Object)this);
        return jdm;
    }

    private synchronized Axis2BlockingClient getSender() {
        if (this.sender != null) {
            return this.sender;
        }
        String axis2repo = (String)this.parameters.get("axis2.repo");
        String axis2Config = (String)this.parameters.get("axis2.config");
        return new Axis2BlockingClient(axis2repo, axis2Config);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void activate() {
        this.active.set(true);
    }

    public void deactivate() {
        this.active.set(false);
    }

    public int getSendAttemptCount() {
        return this.sendAttempts.get();
    }

    public void incrementSendAttemptCount() {
        this.sendAttempts.incrementAndGet();
    }

    public void resetSentAttemptCount() {
        this.sendAttempts.set(0);
    }

    @Override
    public void destroy() {
        try {
            this.scheduler.deleteJob(new JobKey(this.name + "-forward job", "synapse.message.processor.quartz"));
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Error while destroying the task " + (Object)((Object)e)));
        }
        this.state = ScheduledMessageProcessor.State.DESTROY;
    }

    public MessageForwardingProcessorView getView() {
        return this.view;
    }
}

