/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.sampler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processors.ScheduledMessageProcessor;
import org.apache.synapse.message.processors.sampler.SamplingJob;
import org.apache.synapse.message.processors.sampler.SamplingProcessorView;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class SamplingProcessor
extends ScheduledMessageProcessor {
    private static final Log log = LogFactory.getLog(SamplingProcessor.class);
    public static final String CONCURRENCY = "concurrency";
    public static final String SEQUENCE = "sequence";
    private AtomicBoolean active = new AtomicBoolean(true);
    private SamplingProcessorView view;

    @Override
    public void init(SynapseEnvironment se) {
        super.init(se);
        this.view = new SamplingProcessorView(this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "Message Sampling Processor view", this.getName());
    }

    @Override
    protected JobBuilder getJobBuilder() {
        return JobBuilder.newJob(SamplingJob.class).withIdentity(this.name + "-sampling-job", "synapse.message.processor.quartz");
    }

    @Override
    protected JobDataMap getJobDataMap() {
        JobDataMap jdm = new JobDataMap();
        jdm.put("processor.instance", (Object)this);
        return jdm;
    }

    @Override
    public void destroy() {
        try {
            this.scheduler.deleteJob(new JobKey(this.name + "-sampling-job", "synapse.message.processor.quartz"));
        }
        catch (SchedulerException e) {
            log.error((Object)("Error while destroying the task " + (Object)((Object)e)));
        }
        this.state = ScheduledMessageProcessor.State.DESTROY;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void activate() {
        this.active.set(true);
    }

    public void deactivate() {
        this.active.set(false);
    }

    public SamplingProcessorView getView() {
        return this.view;
    }
}

