/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class Replicator {
    private static final Log log = LogFactory.getLog(Replicator.class);

    public static void removeAndReplicateState(String key, ConfigurationContext configCtx) {
        if (configCtx != null && key != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start replicating the property removal with key : " + key));
                }
                configCtx.removePropertyNonReplicable(key);
                org.apache.axis2.clustering.state.Replicator.replicate((AbstractContext)configCtx, (String[])new String[]{key});
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Completed replication of the property removal with key : " + key));
                }
            }
            catch (ClusteringFault clusteringFault) {
                Replicator.handleException("Error during the replicating states ", (Exception)((Object)clusteringFault));
            }
        }
    }

    public static void setAndReplicateState(String key, Object value, ConfigurationContext configCtx) {
        if (configCtx != null && key != null && value != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start replicating the property with key : " + key + " value : " + value));
                }
                configCtx.setNonReplicableProperty(key, value);
                org.apache.axis2.clustering.state.Replicator.replicate((AbstractContext)configCtx, (String[])new String[]{key});
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Completed replication of the property with key : " + key));
                }
            }
            catch (ClusteringFault clusteringFault) {
                Replicator.handleException("Error during the replicating states ", (Exception)((Object)clusteringFault));
            }
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

