/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util;

import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Reader
implements XMLStreamReader {
    protected XMLStreamReader reader;
    private final boolean resettable;
    private static final Log log = LogFactory.getLog(Reader.class);

    Reader(XMLStreamReader reader, boolean resettable) {
        this.reader = reader;
        this.resettable = resettable;
    }

    protected abstract XMLStreamReader newReader();

    public boolean isResettable() {
        this.debug("Entering isResettable....");
        this.debug("resettable = ", this.resettable);
        return this.resettable;
    }

    public void reset() throws WebServiceException {
        this.debug("Entering reset....");
        if (!this.resettable) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"resetReaderErr"));
        }
        this.reader = this.newReader();
        this.debug("Exiting reset....");
    }

    public void close() throws XMLStreamException {
        this.debug("Entering close....");
        this.reader.close();
        this.debug("Exiting close....");
    }

    public int getAttributeCount() {
        this.debug("Entering getAttributeCount....");
        int ac = this.reader.getAttributeCount();
        this.debug("reader.getAttributeCount() = ", ac);
        return ac;
    }

    public String getAttributeLocalName(int arg0) {
        this.debug("Entering getAttributeLocalName....");
        String aln = this.reader.getAttributeLocalName(arg0);
        this.debug("reader.getAttributeLocalName(arg0) = ", aln);
        return aln;
    }

    public QName getAttributeName(int arg0) {
        this.debug("Entering getAttributeName....");
        QName q = this.reader.getAttributeName(arg0);
        this.debug("reader.getAttributeName(arg0) = ", q);
        return q;
    }

    public String getAttributeNamespace(int arg0) {
        this.debug("Entering getAttributeNamespace....");
        String an = this.reader.getAttributeNamespace(arg0);
        this.debug("reader.getAttributeNamespace(arg0) = ", an);
        return an;
    }

    public String getAttributePrefix(int arg0) {
        this.debug("Entering getAttributePrefix....");
        String ap = this.reader.getAttributePrefix(arg0);
        this.debug("reader.getAttributePrefix(arg0) = ", ap);
        return ap;
    }

    public String getAttributeType(int arg0) {
        this.debug("Entering getAttributeType....");
        String at = this.reader.getAttributeType(arg0);
        this.debug("reader.getAttributeType(arg0) = ", at);
        return at;
    }

    public String getAttributeValue(int arg0) {
        this.debug("Entering getAttributeValue....");
        String av = this.reader.getAttributeValue(arg0);
        this.debug("reader.getAttributeValue(arg0) = ", av);
        return av;
    }

    public String getAttributeValue(String arg0, String arg1) {
        this.debug("Entering getAttributeValue....");
        String av = this.reader.getAttributeValue(arg0, arg1);
        this.debug("reader.getAttributeValue(arg0, arg1) = ", av);
        return av;
    }

    public String getCharacterEncodingScheme() {
        this.debug("Entering getCharacterEncodingScheme....");
        String ces = this.reader.getCharacterEncodingScheme();
        this.debug("reader.getCharacterEncodingScheme = ", ces);
        return ces;
    }

    public String getElementText() throws XMLStreamException {
        this.debug("Entering getElementText....");
        String et = this.reader.getElementText();
        this.debug("reader.getElementText = ", et);
        return et;
    }

    public String getEncoding() {
        this.debug("Entering getEncoding....");
        String e = this.reader.getEncoding();
        this.debug("reader.getEncoding() = ", e);
        return e;
    }

    public int getEventType() {
        this.debug("Entering getEventType....");
        int et = this.reader.getEventType();
        this.debug("reader.getEventType() = ", et);
        return et;
    }

    public String getLocalName() {
        this.debug("Entering getLocation....");
        String ln = this.reader.getLocalName();
        this.debug("reader.getLocalName() = ", ln);
        return ln;
    }

    public Location getLocation() {
        this.debug("Entering getLocation....");
        Location l = this.reader.getLocation();
        this.debug("reader.getLocation() = ", l);
        return l;
    }

    public QName getName() {
        this.debug("Entering getName....");
        QName qn = this.reader.getName();
        this.debug("reader.getName() = ", qn);
        return qn;
    }

    public NamespaceContext getNamespaceContext() {
        this.debug("Entering getNamespaceContext....");
        NamespaceContext nsContext = this.reader.getNamespaceContext();
        this.debug("reader.getNamespaceContext() = ", nsContext);
        return nsContext;
    }

    public int getNamespaceCount() {
        this.debug("Entering getNamespaceCount....");
        int nsCount = this.reader.getNamespaceCount();
        this.debug("reader.getNamespaceCount() = ", nsCount);
        return nsCount;
    }

    public String getNamespacePrefix(int arg0) {
        this.debug("Entering getNamespacePrefix....");
        String nsPrefix = this.reader.getNamespacePrefix(arg0);
        this.debug("reader.getNamespacePrefix(arg0 = ", nsPrefix);
        return nsPrefix;
    }

    public String getNamespaceURI() {
        this.debug("Entering getNamespaceURI....");
        String nsUri = this.reader.getNamespaceURI();
        this.debug("reader.getNamespaceURI() = ", nsUri);
        return nsUri;
    }

    public String getNamespaceURI(int arg0) {
        this.debug("Entering getNamespaceURI....");
        String nsUri = this.reader.getNamespaceURI(arg0);
        this.debug("reader.getNamespaceURI(arg0) = ", nsUri);
        return nsUri;
    }

    public String getNamespaceURI(String arg0) {
        this.debug("Entering getNamespaceURI....");
        String nsUri = this.reader.getNamespaceURI(arg0);
        this.debug("reader.getNamespaceURI(arg0) = ", nsUri);
        return nsUri;
    }

    public String getPIData() {
        this.debug("Entering getPIData....");
        String pid = this.reader.getPIData();
        this.debug("reader.getPIData() = ", pid);
        return pid;
    }

    public String getPITarget() {
        this.debug("Entering getPITarget....");
        String pit = this.reader.getPITarget();
        this.debug("reader.getPITarget() = ", pit);
        return pit;
    }

    public String getPrefix() {
        this.debug("Entering getPrefix....");
        String gpf = this.reader.getPrefix();
        this.debug("reader.getPrefix() = ", gpf);
        return gpf;
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        this.debug("Entering getProperty for ..." + arg0);
        Object o = this.reader.getProperty(arg0);
        this.debug("reader.getProperty(arg0) = ", o);
        return o;
    }

    public String getText() {
        this.debug("Entering getText....");
        String gt = this.reader.getText();
        this.debug("reader.getText() = ", gt);
        return gt;
    }

    public char[] getTextCharacters() {
        this.debug("Entering getTextCharacters....");
        char[] gtc = this.reader.getTextCharacters();
        this.debug("reader.getTextCharacters() = ", Arrays.toString(gtc));
        return gtc;
    }

    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        this.debug("Entering getTextCharacters....");
        int gtc = this.reader.getTextCharacters(arg0, arg1, arg2, arg3);
        this.debug("reader.getTextCharacters() = ", gtc);
        return gtc;
    }

    public int getTextLength() {
        this.debug("Entering getTextLength....");
        int gtl = this.reader.getTextLength();
        this.debug("reader.getTextLength() = ", gtl);
        return gtl;
    }

    public int getTextStart() {
        this.debug("Entering getTextStart....");
        int gts = this.reader.getTextStart();
        this.debug("reader.getTextStart() = ", gts);
        return this.reader.getTextStart();
    }

    public String getVersion() {
        this.debug("Entering getVersion....");
        String gv = this.reader.getVersion();
        this.debug("reader.getVersion() = ", gv);
        return gv;
    }

    public boolean hasName() {
        this.debug("Entering hasName....");
        boolean b = this.reader.hasName();
        this.debug("reader.hasName() = ", b);
        return b;
    }

    public boolean hasNext() throws XMLStreamException {
        this.debug("Entering hasNext....");
        boolean b = this.reader.hasNext();
        this.debug("reader.hasNext() = ", b);
        return b;
    }

    public boolean hasText() {
        this.debug("Entering hasText....");
        boolean b = this.reader.hasText();
        this.debug("reader.hasText() = ", b);
        return b;
    }

    public boolean isAttributeSpecified(int arg0) {
        this.debug("Entering isAttributeSpecified....");
        boolean b = this.reader.isAttributeSpecified(arg0);
        this.debug("Entering reader.isAttributeSpecified(arg0) ", b);
        return b;
    }

    public boolean isCharacters() {
        this.debug("Entering isCharacters....");
        boolean b = this.reader.isCharacters();
        this.debug("reader.isCharacters() = ", b);
        return b;
    }

    public boolean isEndElement() {
        this.debug("Entering isEndElement....");
        boolean b = this.reader.isEndElement();
        this.debug("reader.isEndElement() = ", b);
        return b;
    }

    public boolean isStandalone() {
        this.debug("Entering isStandalone....");
        boolean b = this.reader.isStandalone();
        this.debug("reader.isStandalone() = ", b);
        return b;
    }

    public boolean isStartElement() {
        this.debug("Entering isStartElement....");
        boolean b = this.reader.isStartElement();
        this.debug("reader.isStartElement() = ", b);
        return b;
    }

    public boolean isWhiteSpace() {
        this.debug("Entering isWhiteSpace....");
        boolean b = this.reader.isWhiteSpace();
        this.debug("reader.isWhiteSpace() = ", b);
        return b;
    }

    public int next() throws XMLStreamException {
        this.debug("Entering next....");
        int nxt = this.reader.next();
        this.debug("reader.next() = ", nxt);
        return nxt;
    }

    public int nextTag() throws XMLStreamException {
        this.debug("Entering nextTag....");
        int tag = this.reader.nextTag();
        this.debug("reader.nextTag() = ", tag);
        return tag;
    }

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        this.debug("Entering require....");
        this.debug("reader.require -> arg0 = ", arg0, " ,arg1 = ", arg1, " ,arg2 = ", arg2);
        this.reader.require(arg0, arg1, arg2);
    }

    public boolean standaloneSet() {
        this.debug("Entering standaloneSet....");
        boolean b = this.reader.standaloneSet();
        this.debug("reader.standaloneSet() = ", b);
        return b;
    }

    private void debug(Object ... messages) {
        if (log.isDebugEnabled()) {
            StringBuffer sbuff = new StringBuffer();
            for (Object msg : messages) {
                sbuff.append(msg);
            }
            log.debug((Object)sbuff.toString());
        }
    }
}

