/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format.hessian;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.util.SynapseBinaryDataSource;

public class HessianMessageBuilder
implements Builder {
    private static final Log log = LogFactory.getLog(HessianMessageBuilder.class);

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start building the hessian message in to a HessianDataSource");
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://ws.apache.org/ns/axis2/hessian", "hs");
        OMElement element = factory.createOMElement("hessianDataSource", ns);
        try {
            Parameter synEnv = messageContext.getConfigurationContext().getAxisConfiguration().getParameter("synapse.env");
            PushbackInputStream pis = this.detectAndMarkMessageFault(messageContext, inputStream);
            DataHandler dataHandler = synEnv != null && synEnv.getValue() != null ? new DataHandler((DataSource)new SynapseBinaryDataSource((InputStream)pis, contentType, (SynapseEnvironment)synEnv.getValue())) : new DataHandler((DataSource)new SynapseBinaryDataSource((InputStream)pis, contentType));
            OMText textData = factory.createOMText((Object)dataHandler, true);
            element.addChild((OMNode)textData);
            messageContext.setProperty("FAULTS_AS_HTTP_200", (Object)"TRUE");
        }
        catch (IOException e) {
            String msg = "Unable to create the HessianDataSource";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Building the hessian message using HessianDataSource is successful");
        }
        return element;
    }

    private PushbackInputStream detectAndMarkMessageFault(MessageContext messageContext, InputStream inputStream) throws IOException {
        int bytesToRead = 4;
        PushbackInputStream pis = new PushbackInputStream(inputStream, bytesToRead);
        byte[] headerBytes = new byte[bytesToRead];
        int n = pis.read(headerBytes);
        if (n == bytesToRead) {
            if (headerBytes[bytesToRead - 1] == 102 || headerBytes[bytesToRead - 1] == 70) {
                messageContext.setProperty("FAULT_MESSAGE", (Object)"TRUE");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Hessian fault detected, marking in Axis2 message context");
                }
            }
            pis.unread(headerBytes);
        } else if (n > 0) {
            byte[] bytesRead = new byte[n];
            System.arraycopy(headerBytes, 0, bytesRead, 0, n);
            pis.unread(bytesRead);
        }
        return pis;
    }
}

