/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactory;
import org.apache.synapse.commons.evaluators.source.HeaderTextRetriever;
import org.apache.synapse.commons.evaluators.source.ParameterTextRetriever;
import org.apache.synapse.commons.evaluators.source.PropertyTextRetriever;
import org.apache.synapse.commons.evaluators.source.SOAPEnvelopeTextRetriever;
import org.apache.synapse.commons.evaluators.source.SourceTextRetriever;
import org.apache.synapse.commons.evaluators.source.URLTextRetriever;

public abstract class TextProcessingEvaluatorFactory
implements EvaluatorFactory {
    protected Log log = LogFactory.getLog(this.getClass());

    protected SourceTextRetriever getSourceTextRetriever(OMElement e) throws EvaluatorException {
        OMAttribute typeAttr = e.getAttribute(new QName("type"));
        OMAttribute sourceAttr = e.getAttribute(new QName("source"));
        SourceTextRetriever textRetriever = null;
        if (typeAttr != null) {
            String value = typeAttr.getAttributeValue();
            if (value.equals("header")) {
                if (sourceAttr != null) {
                    textRetriever = new HeaderTextRetriever(sourceAttr.getAttributeValue());
                } else {
                    this.handleException("source attribute is required");
                }
            } else if (value.equals("param")) {
                if (sourceAttr != null) {
                    textRetriever = new ParameterTextRetriever(sourceAttr.getAttributeValue());
                } else {
                    this.handleException("source attribute is required");
                }
            } else if (value.equals("url")) {
                textRetriever = new URLTextRetriever();
                if (sourceAttr != null) {
                    ((URLTextRetriever)textRetriever).setSource(sourceAttr.getAttributeValue());
                }
            } else if (value.equals("property")) {
                if (sourceAttr != null) {
                    textRetriever = new PropertyTextRetriever(sourceAttr.getAttributeValue());
                } else {
                    this.handleException("source attribute is required");
                }
            } else if (value.equals("soap")) {
                if (sourceAttr != null) {
                    textRetriever = new SOAPEnvelopeTextRetriever(sourceAttr.getAttributeValue());
                } else {
                    this.handleException("source attribute is required");
                }
            } else {
                this.handleException("Unknown equal evaluator type: " + value);
            }
        } else if (sourceAttr != null) {
            textRetriever = new HeaderTextRetriever(sourceAttr.getAttributeValue());
        } else {
            this.handleException("source attribute is required");
        }
        return textRetriever;
    }

    protected void handleException(String message) throws EvaluatorException {
        this.log.error((Object)message);
        throw new EvaluatorException(message);
    }
}

