/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.jmx;

import java.util.Collections;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.synapse.securevault.secret.SecretInformation;

public class JmxSecretAuthenticator
implements JMXAuthenticator {
    private SecretInformation secretInformation;

    public JmxSecretAuthenticator(SecretInformation secretInformation) {
        this.secretInformation = secretInformation;
    }

    @Override
    public Subject authenticate(Object credentials) {
        String password;
        if (credentials == null) {
            throw new SecurityException("Credentials required");
        }
        if (!(credentials instanceof String[])) {
            throw new SecurityException("Credentials should be String[]");
        }
        String[] aCredentials = (String[])credentials;
        if (aCredentials.length < 2) {
            throw new SecurityException("Credentials should have the username and password");
        }
        String username = aCredentials[0];
        String string = password = aCredentials[1] != null ? aCredentials[1] : "";
        if (this.secretInformation.getUser().equals(username) && password.equals(this.secretInformation.getResolvedSecret())) {
            return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        throw new SecurityException("Username and/or password are incorrect, or you do not have the necessary access rights.");
    }
}

