/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.dataretrieval.SchemaSupplier;
import org.apache.axis2.dataretrieval.WSDLSupplier;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.catalog.impl.OASISCatalogManager;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.util.CatalogURIResolver;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSRIWSDLGenerator
implements SchemaSupplier,
WSDLSupplier {
    private static final Log log = LogFactory.getLog(JAXWSRIWSDLGenerator.class);
    private String classPath;
    private AxisService axisService;
    private AxisConfiguration axisConfiguration;
    private boolean init = false;
    private HashMap<String, XmlSchema> docMap;
    private HashMap<String, Definition> wsdlDefMap;

    public JAXWSRIWSDLGenerator(AxisService axisService) {
        this.axisService = axisService;
    }

    public JAXWSRIWSDLGenerator(AxisService axisService, AxisConfiguration axisConfig) {
        this.axisService = axisService;
        this.axisConfiguration = axisConfig;
    }

    public void generateWsdl(String className, String bindingType) throws WebServiceException {
        this.generateWsdl(className, bindingType, null);
    }

    public void generateWsdl(String className, String bindingType, JAXWSCatalogManager catalogManager) throws WebServiceException {
        Object obj;
        File tempFile;
        if (this.axisConfiguration == null) {
            this.axisConfiguration = this.axisService.getAxisConfiguration();
        }
        if ((tempFile = (File)this.axisConfiguration.getParameterValue("artifactsDIR")) == null) {
            tempFile = new File(JAXWSRIWSDLGenerator.getProperty_doPriv("java.io.tmpdir"), "_axis2");
        }
        Parameter servletConfigParam = this.axisConfiguration.getParameter(HTTPConstants.HTTP_SERVLETCONFIG);
        String webBase = null;
        if (servletConfigParam != null && (obj = servletConfigParam.getValue()) instanceof ServletConfig) {
            ServletConfig servletConfig = (ServletConfig)obj;
            ServletContext servletContext = servletConfig.getServletContext();
            webBase = servletContext.getRealPath("/WEB-INF");
        }
        if (this.classPath == null) {
            this.classPath = this.getDefaultClasspath(webBase);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("For implementation class " + className + " WsGen classpath: " + this.classPath));
        }
        String localOutputDirectory = tempFile.getAbsolutePath() + className + "_" + this.axisService.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Output directory for generated WSDL file: " + localOutputDirectory));
        }
        try {
            Class<?> clazz;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Generating new WSDL Definition");
            }
            this.createOutputDirectory(localOutputDirectory);
            try {
                clazz = Class.forName("com.sun.tools.internal.ws.spi.WSToolsObjectFactory");
            }
            catch (Throwable t) {
                clazz = Class.forName("com.sun.tools.ws.spi.WSToolsObjectFactory");
            }
            Method m1 = clazz.getMethod("newInstance", new Class[0]);
            Object factory = m1.invoke((Object)new Object[0], new Object[0]);
            String[] arguments = this.getWsGenArguments(className, bindingType, localOutputDirectory);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Method m2 = clazz.getMethod("wsgen", OutputStream.class, String[].class);
            m2.invoke(factory, os, arguments);
            ((OutputStream)os).close();
            this.wsdlDefMap = this.readInWSDL(localOutputDirectory);
            if (this.wsdlDefMap.isEmpty()) {
                throw new Exception("A WSDL Definition could not be generated for the implementation class: " + className);
            }
            this.docMap = this.readInSchema(localOutputDirectory, catalogManager);
        }
        catch (Throwable t) {
            String msg = "Error occurred generating WSDL file for Web service implementation class {" + className + "}";
            log.error((Object)msg, t);
            throw new WebServiceException(msg, t);
        }
    }

    private String[] getWsGenArguments(String className, String bindingType, String localOutputDirectory) throws WebServiceException {
        String[] arguments = null;
        if (bindingType == null || bindingType.equals("") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Generating WSDL with SOAP 1.1 binding type");
            }
            arguments = new String[]{"-cp", this.classPath, className, "-keep", "-wsdl:soap1.1", "-d", localOutputDirectory};
        } else if (bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Generating WSDL with SOAP 1.2 binding type");
            }
            arguments = new String[]{"-cp", this.classPath, className, "-keep", "-extension", "-wsdl:Xsoap1.2", "-d", localOutputDirectory};
        } else {
            throw new WebServiceException("The binding " + bindingType + " specified by the " + "class " + className + " cannot be used to generate a WSDL. Please choose " + "a supported binding type.");
        }
        return arguments;
    }

    private HashMap<String, Definition> readInWSDL(String localOutputDirectory) throws Exception {
        List<File> wsdlFiles = this.getWSDLFiles(localOutputDirectory);
        HashMap<String, Definition> wsdlDefMap = new HashMap<String, Definition>();
        for (File wsdlFile : wsdlFiles) {
            String msg;
            if (wsdlFile == null) continue;
            try {
                Definition definition;
                block7: {
                    WSDLReader wsdlReader = WSDLUtil.newWSDLReaderWithPopulatedExtensionRegistry();
                    InputStream is = wsdlFile.toURI().toURL().openStream();
                    definition = wsdlReader.readWSDL(localOutputDirectory, new InputSource(is));
                    try {
                        definition.setDocumentBaseURI(wsdlFile.toURI().toString());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Set base document URI for generated WSDL: " + wsdlFile.toURI().toString()));
                        }
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block7;
                        log.debug((Object)("Could not set base document URI for generated WSDL: " + wsdlFile.getAbsolutePath() + " : " + t.toString()));
                    }
                }
                wsdlDefMap.put(wsdlFile.getName().toLowerCase(), definition);
            }
            catch (WSDLException e) {
                msg = "Error occurred while attempting to create Definition from generated WSDL file {" + wsdlFile.getName() + "}";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg);
            }
            catch (IOException e) {
                msg = "Error occurred while attempting to create Definition from generated WSDL file  {" + wsdlFile.getName() + "}";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg);
            }
        }
        return wsdlDefMap;
    }

    private List<File> getWSDLFiles(String localOutputDirectory) {
        File classDirectory = new File(localOutputDirectory);
        ArrayList<File> wsdlFiles = new ArrayList<File>();
        if (classDirectory.isDirectory()) {
            File[] files;
            for (File file : files = classDirectory.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(".wsdl")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Located generated WSDL file: " + fileName));
                }
                wsdlFiles.add(file);
            }
        }
        return wsdlFiles;
    }

    private void createOutputDirectory(String localOutputDirectory) {
        File directory = new File(localOutputDirectory);
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    private HashMap<String, XmlSchema> readInSchema(String localOutputDirectory, JAXWSCatalogManager catalogManager) throws Exception {
        try {
            XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
            if (catalogManager != null) {
                schemaCollection.setSchemaResolver((URIResolver)new CatalogURIResolver(catalogManager));
            }
            schemaCollection.setBaseUri(new File(localOutputDirectory).getAbsolutePath());
            HashMap<String, XmlSchema> docMap = new HashMap<String, XmlSchema>();
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            List<File> schemaFiles = this.getSchemaFiles(localOutputDirectory);
            for (File schemaFile : schemaFiles) {
                Document parsedDoc = fac.newDocumentBuilder().parse(schemaFile.toURI().toURL().toString());
                XmlSchema doc = schemaCollection.read(parsedDoc.getDocumentElement(), UIDGenerator.generateUID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read in schema file: " + schemaFile.getName()));
                }
                docMap.put(schemaFile.getName(), doc);
            }
            return docMap;
        }
        catch (Exception e) {
            String msg = "Error occurred while attempting to read generated schema file";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    private List<File> getSchemaFiles(String localOutputDirectory) {
        ArrayList<File> schemaFiles = new ArrayList<File>();
        File classDirectory = new File(localOutputDirectory);
        if (classDirectory.isDirectory()) {
            File[] files;
            for (File file : files = classDirectory.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(".xsd")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Located generated schema file: " + fileName));
                }
                schemaFiles.add(file);
            }
        }
        return schemaFiles;
    }

    public Definition getWSDL(AxisService service) throws AxisFault {
        Object value;
        Parameter wsdlParameter = service.getParameter("wsdl4jDefinition");
        if (wsdlParameter != null && (value = wsdlParameter.getValue()) != null) {
            return (Definition)value;
        }
        this.initialize(service);
        return this.wsdlDefMap.values().iterator().next();
    }

    private synchronized void initialize(AxisService service) {
        String className = (String)this.axisService.getParameter("ServiceClass").getValue();
        if (!this.init) {
            this.generateWsdl(className, "http://schemas.xmlsoap.org/wsdl/soap/http", JAXWSRIWSDLGenerator.getCatalogManager(service));
            this.init = true;
        }
    }

    public XmlSchema getSchema(AxisService service, String xsd) throws AxisFault {
        ArrayList list;
        Parameter wsdlParameter = service.getParameter("wsdl4jDefinition");
        if (wsdlParameter != null && (list = service.getSchema()).size() > 0) {
            if (xsd == null || xsd.length() == 0) {
                return (XmlSchema)list.get(0);
            }
            for (XmlSchema schema : list) {
                XmlSchema[] schemas = SchemaUtil.getAllSchemas((XmlSchema)schema);
                for (int i = 0; i < schemas.length; ++i) {
                    String uri = schemas[i].getSourceURI();
                    if (uri == null || !uri.endsWith(xsd)) continue;
                    return schemas[i];
                }
            }
            return (XmlSchema)list.get(0);
        }
        this.initialize(service);
        XmlSchema schema = this.docMap.get(xsd);
        if (schema == null) {
            this.docMap.values().iterator().next();
        }
        return schema;
    }

    public static String expandDirs(String dirPaths) {
        StringTokenizer st = new StringTokenizer(dirPaths, File.pathSeparator);
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            String d = st.nextToken();
            File dir = new File(d);
            if (!dir.isDirectory()) continue;
            File[] files = dir.listFiles(new JavaArchiveFilter());
            for (int i = 0; i < files.length; ++i) {
                buffer.append(files[i]).append(File.pathSeparator);
            }
        }
        return buffer.toString();
    }

    public static boolean isJar(InputStream is) {
        try {
            JarInputStream jis = new JarInputStream(is);
            if (jis.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static JAXWSCatalogManager getCatalogManager(AxisService service) {
        Parameter param = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        if (param != null) {
            EndpointDescription ed = (EndpointDescription)param.getValue();
            return ed.getServiceDescription().getCatalogManager();
        }
        return new OASISCatalogManager();
    }

    public String getDefaultClasspath(String webBase) {
        URL serviceArchive;
        HashSet<String> classpath = new HashSet<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        JAXWSRIWSDLGenerator.fillClassPath(cl, classpath);
        if (webBase != null) {
            JAXWSRIWSDLGenerator.addPath(classpath, webBase + File.separatorChar + "classes");
            try {
                String libBase = webBase + File.separatorChar + "lib";
                File libDir = new File(libBase);
                String[] jarFiles = libDir.list();
                for (int i = 0; i < jarFiles.length; ++i) {
                    String jarFile = jarFiles[i];
                    if (!jarFile.endsWith(".jar")) continue;
                    JAXWSRIWSDLGenerator.addPath(classpath, libBase + File.separatorChar + jarFile);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((serviceArchive = this.axisService.getFileName()) != null) {
            try {
                URL[] urls;
                for (URL url : urls = Utils.getURLsForAllJars((URL)serviceArchive, null)) {
                    classpath.add(Utils.toFile((URL)url).getCanonicalPath());
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        JAXWSRIWSDLGenerator.getClassPathFromDirectoryProperty(classpath, "axis.ext.dirs");
        JAXWSRIWSDLGenerator.getClassPathFromProperty(classpath, "org.apache.catalina.jsp_classpath");
        JAXWSRIWSDLGenerator.getClassPathFromProperty(classpath, "ws.ext.dirs");
        JAXWSRIWSDLGenerator.getClassPathFromProperty(classpath, "com.ibm.websphere.servlet.application.classpath");
        JAXWSRIWSDLGenerator.getClassPathFromProperty(classpath, "java.class.path");
        JAXWSRIWSDLGenerator.getClassPathFromDirectoryProperty(classpath, "java.ext.dirs");
        JAXWSRIWSDLGenerator.getClassPathFromProperty(classpath, "sun.boot.class.path");
        StringBuffer path = new StringBuffer();
        for (String s : classpath) {
            path.append(s);
            path.append(File.pathSeparatorChar);
        }
        log.debug((Object)path);
        return path.toString();
    }

    private static void addPath(HashSet classpath, String s) {
        String path = s.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar).trim();
        File file = new File(path);
        if (JAXWSRIWSDLGenerator.fileExists(file).booleanValue()) {
            path = file.getAbsolutePath();
            classpath.add(path);
        }
    }

    private static void getClassPathFromDirectoryProperty(HashSet classpath, String property) {
        String dirs = JAXWSRIWSDLGenerator.getProperty_doPriv(property);
        String path = null;
        try {
            path = JAXWSRIWSDLGenerator.expandDirs(dirs);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (path != null) {
            JAXWSRIWSDLGenerator.addPath(classpath, path);
        }
    }

    private static String getProperty_doPriv(final String property) {
        return (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(property);
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
    }

    private static void getClassPathFromProperty(HashSet classpath, String property) {
        String path = JAXWSRIWSDLGenerator.getProperty_doPriv(property);
        if (path != null) {
            JAXWSRIWSDLGenerator.addPath(classpath, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillClassPath(ClassLoader cl, HashSet classpath) {
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)cl).getURLs();
                for (int i = 0; urls != null && i < urls.length; ++i) {
                    String path = urls[i].getPath();
                    if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
                        path = path.substring(1);
                    }
                    JAXWSRIWSDLGenerator.addPath(classpath, URLDecoder.decode(path));
                    File file = new File(urls[i].getFile());
                    if (!file.isFile()) continue;
                    FileInputStream fis = null;
                    try {
                        Attributes attributes;
                        JarFile jar;
                        Manifest manifest;
                        fis = new FileInputStream(file);
                        if (!JAXWSRIWSDLGenerator.isJar(fis) || (manifest = (jar = new JarFile(file)).getManifest()) == null || (attributes = manifest.getMainAttributes()) == null) continue;
                        String s = attributes.getValue(Attributes.Name.CLASS_PATH);
                        String base = file.getParent();
                        if (s == null) continue;
                        StringTokenizer st = new StringTokenizer(s, " ");
                        while (st.hasMoreTokens()) {
                            String t = st.nextToken();
                            JAXWSRIWSDLGenerator.addPath(classpath, base + File.separatorChar + t);
                        }
                        continue;
                    }
                    catch (IOException ioe) {
                        continue;
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ioe2) {}
                        }
                    }
                }
            }
            cl = cl.getParent();
        }
    }

    private static Boolean fileExists(final File file) {
        Boolean exists = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
        return exists;
    }

    private static class JavaArchiveFilter
    implements FileFilter {
        private JavaArchiveFilter() {
        }

        public boolean accept(File file) {
            String name = file.getName().toLowerCase();
            return name.endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

