/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionConstants;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.i18n.CodegenMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodegenConfigLoader
implements CommandLineOptionConstants {
    CodegenConfigLoader() {
    }

    public static void loadConfig(CodeGenConfiguration config, Map<String, CommandLineOption> optionMap) {
        String optionValue;
        String value;
        boolean syncFlagPresent;
        String outputLocation = ".";
        CommandLineOption commandLineOption = CodegenConfigLoader.loadOption("o", "output", optionMap);
        if (commandLineOption != null) {
            config.setoutputSourceLocation(true);
            outputLocation = commandLineOption.getOptionValue();
        }
        File outputLocationFile = new File(outputLocation);
        config.setOutputLocation(outputLocationFile);
        if (outputLocationFile.exists()) {
            if (outputLocationFile.isFile()) {
                throw new RuntimeException(CodegenMessages.getMessage("options.notADirectoryException"));
            }
        } else {
            outputLocationFile.mkdirs();
        }
        config.setServerSide(CodegenConfigLoader.loadOption("ss", "server-side", optionMap) != null);
        config.setGenerateDeployementDescriptor(CodegenConfigLoader.loadOption("sd", "service-description", optionMap) != null);
        config.setWriteTestCase(CodegenConfigLoader.loadOption("t", "test-case", optionMap) != null);
        config.setSkipWriteWSDLs(CodegenConfigLoader.loadOption(null, "noWSDL", optionMap) != null);
        config.setSkipMessageReceiver(CodegenConfigLoader.loadOption(null, "noMessageReceiver", optionMap) != null);
        config.setSkipBuildXML(CodegenConfigLoader.loadOption(null, "noBuildXML", optionMap) != null);
        boolean asyncFlagPresent = CodegenConfigLoader.loadOption("a", "async", optionMap) != null;
        boolean bl = syncFlagPresent = CodegenConfigLoader.loadOption("s", "sync", optionMap) != null;
        if (asyncFlagPresent && !syncFlagPresent) {
            config.setAsyncOn(true);
            config.setSyncOn(false);
        }
        if (syncFlagPresent && !asyncFlagPresent) {
            config.setAsyncOn(false);
            config.setSyncOn(true);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("p", "package", optionMap)) != null) {
            config.setPackageName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("l", "language", optionMap)) != null) {
            config.setOutputLanguage(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("d", "databinding-method", optionMap)) != null) {
            config.setDatabindingType(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("u", "unpack-classes", optionMap)) != null) {
            config.setPackClasses(false);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("S", "source-folder", optionMap)) != null) {
            config.setSourceLocation(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("R", "resource-folder", optionMap)) != null) {
            config.setResourceLocation(commandLineOption.getOptionValue());
        }
        config.setPortName((commandLineOption = CodegenConfigLoader.loadOption("pn", "port-name", optionMap)) != null ? commandLineOption.getOptionValue() : null);
        commandLineOption = CodegenConfigLoader.loadOption("sn", "service-name", optionMap);
        config.setServiceName(commandLineOption != null ? commandLineOption.getOptionValue() : null);
        commandLineOption = CodegenConfigLoader.loadOption("r", "repository-path", optionMap);
        config.setRepositoryPath(commandLineOption != null ? commandLineOption.getOptionValue() : null);
        config.setServerSideInterface(CodegenConfigLoader.loadOption("ssi", "serverside-interface", optionMap) != null);
        config.setGenerateAll(CodegenConfigLoader.loadOption("g", "generate-all", optionMap) != null);
        commandLineOption = CodegenConfigLoader.loadOption("em", "external-mapping", optionMap);
        if (commandLineOption != null) {
            try {
                config.setTypeMappingFile(new File(commandLineOption.getOptionValue()));
            }
            catch (Exception e) {
                throw new RuntimeException(CodegenMessages.getMessage("options.nomappingFile"), e);
            }
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("ns2p", "namespace2package", optionMap)) != null && (value = commandLineOption.getOptionValue()) != null) {
            HashMap<String, String> map;
            if (value.indexOf(61) != -1) {
                String[] valuepairs = value.split(",");
                if (valuepairs.length > 0) {
                    map = new HashMap<String, String>(valuepairs.length);
                    for (int i = 0; i < valuepairs.length; ++i) {
                        String[] values = valuepairs[i].split("=");
                        if (values.length != 2) continue;
                        map.put(values[0], values[1]);
                    }
                    config.setUri2PackageNameMap(map);
                }
            } else {
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(value));
                    map = new HashMap();
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        map.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.setUri2PackageNameMap(map);
                }
                catch (IOException e) {
                    throw new RuntimeException(CodegenMessages.getMessage("options.noFile", value), e);
                }
            }
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("uw", "unwrap-params", optionMap)) != null) {
            config.setParametersWrapped(false);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("wv", "wsdl-version", optionMap)) != null && ("2.0".equals(optionValue = commandLineOption.getOptionValue()) || "2".equals(optionValue))) {
            config.setWSDLVersion("2.0");
        }
        config.setFlattenFiles(CodegenConfigLoader.loadOption("f", "flatten-files", optionMap) != null);
        commandLineOption = CodegenConfigLoader.loadOption("b", "backword-compatible", optionMap);
        if (commandLineOption != null) {
            config.setBackwordCompatibilityMode(true);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("sp", "suppress-prefixes", optionMap)) != null) {
            config.setSuppressPrefixesMode(true);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("xc", "xsdconfig", optionMap)) != null) {
            config.getProperties().put("xc", commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption(null, "http-proxy-host", optionMap)) != null) {
            System.setProperty("http.proxyHost", commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption(null, "http-proxy-port", optionMap)) != null) {
            System.setProperty("http.proxyPort", commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("ep", "exclude-packages", optionMap)) != null) {
            config.setExcludeProperties(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("sin", "skelton-interface-name", optionMap)) != null) {
            config.setSkeltonInterfaceName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("scn", "skelton-class-name", optionMap)) != null) {
            config.setSkeltonClassName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("ebc", "exception-base-class", optionMap)) != null) {
            config.setExceptionBaseClassName(commandLineOption.getOptionValue());
        }
        config.setAllPorts(CodegenConfigLoader.loadOption("ap", "all-ports", optionMap) != null);
        config.setOverride(CodegenConfigLoader.loadOption("or", "over-ride", optionMap) != null);
        config.setOverrideAbsoluteAddress(CodegenConfigLoader.loadOption("oaa", "override-absolute-address", optionMap) != null);
        config.setUseOperationName(CodegenConfigLoader.loadOption("uon", "use-operation-name", optionMap) != null);
        for (Map.Entry<String, CommandLineOption> entry : optionMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("E")) continue;
            config.getProperties().put(key.replaceFirst("E", ""), entry.getValue().getOptionValue());
        }
    }

    private static CommandLineOption loadOption(String shortOption, String longOption, Map<String, CommandLineOption> options) {
        CommandLineOption option = null;
        if (longOption != null && (option = options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = options.get(shortOption);
        }
        return option;
    }
}

