/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Map;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.util.OptionsValidator;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.jaxws.JAXWSCodeGenerationEngine;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.WSDL2JavaOptionsValidator;

public class WSDL2Code {
    public static void main(String[] args) throws Exception {
        CommandLineOptionParser commandLineOptionParser = new CommandLineOptionParser(args);
        WSDL2Code.checkAuthentication(commandLineOptionParser);
        WSDL2Code.setSystemProperties(commandLineOptionParser);
        if (WSDL2Code.isJwsOptionEnabled(commandLineOptionParser)) {
            new JAXWSCodeGenerationEngine(commandLineOptionParser, args).generate();
            return;
        }
        if (WSDL2Code.isOptionsValid(commandLineOptionParser)) {
            new CodeGenerationEngine(commandLineOptionParser).generate();
        } else {
            WSDL2Code.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println(CodegenMessages.getMessage("wsdl2code.arg"));
        System.out.println(CodegenMessages.getMessage("wsdl2code.arg1"));
        for (int i = 2; i <= 53; ++i) {
            System.out.println("  " + CodegenMessages.getMessage("wsdl2code.arg" + i));
        }
    }

    private static boolean isOptionsValid(CommandLineOptionParser parser) {
        boolean isValid = true;
        if (parser.getInvalidOptions((OptionsValidator)new WSDL2JavaOptionsValidator()).size() > 0) {
            isValid = false;
        }
        if (null == parser.getAllOptions().get("uri")) {
            isValid = false;
        }
        return isValid;
    }

    private static boolean isJwsOptionEnabled(CommandLineOptionParser parser) {
        Map allOptions = parser.getAllOptions();
        CommandLineOption option = (CommandLineOption)allOptions.get("jws");
        return option != null;
    }

    private static void checkAuthentication(CommandLineOptionParser commandLineOptionParser) {
        String userName = null;
        String password = null;
        Map allOptions = commandLineOptionParser.getAllOptions();
        CommandLineOption userOption = (CommandLineOption)allOptions.get("http-proxy-user");
        CommandLineOption passwordOption = (CommandLineOption)allOptions.get("http-proxy-password");
        CommandLineOption urlOption = (CommandLineOption)allOptions.get("uri");
        if (urlOption == null) {
            return;
        }
        if (userOption != null) {
            userName = userOption.getOptionValue();
        }
        if (passwordOption != null) {
            password = passwordOption.getOptionValue();
        }
        if (userName == null) {
            URL url = null;
            try {
                url = new URL(urlOption.getOptionValue());
            }
            catch (MalformedURLException e) {
                return;
            }
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                int i = userInfo.indexOf(58);
                if (i >= 0) {
                    userName = userInfo.substring(0, i);
                    password = userInfo.substring(i + 1);
                } else {
                    userName = userInfo;
                }
            }
        }
        if (userName != null) {
            final String user = userName;
            final String pass = password == null ? "" : password;
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
        }
    }

    private static void setSystemProperties(CommandLineOptionParser commandLineOptionParser) {
        Map allOptions = commandLineOptionParser.getAllOptions();
        if (allOptions != null) {
            for (String key : allOptions.keySet()) {
                if (key == null || key.length() <= 0 || !key.startsWith("D") || !key.contains("=")) continue;
                int splitIndex = key.indexOf("=");
                String pKey = key.substring(1, splitIndex);
                String pValue = key.substring(splitIndex + 1);
                if (pKey == null || pValue == null) continue;
                System.setProperty(pKey, pValue);
            }
        }
    }
}

