/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.impl.domainbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleConfiguration;

public class DomainBaseThrottleConfiguration
implements ThrottleConfiguration {
    private static Log log = LogFactory.getLog((String)DomainBaseThrottleConfiguration.class.getName());
    private String keyOfOther;
    private CallerConfiguration defaultCallerConfiguration;
    private Map configurationsMap = new HashMap();

    public CallerConfiguration getCallerConfiguration(String ID) {
        if (ID.equals("other")) {
            return this.defaultCallerConfiguration;
        }
        String key = this.getConfigurationKeyOfCaller(ID);
        if (key != null) {
            if (key.equals("other")) {
                return this.defaultCallerConfiguration;
            }
            return (CallerConfiguration)this.configurationsMap.get(key);
        }
        return null;
    }

    public void addCallerConfiguration(CallerConfiguration configuration) {
        String key = configuration.getID();
        if (key == null) {
            return;
        }
        if ((key = key.trim()).equals("other")) {
            this.keyOfOther = "other";
            this.defaultCallerConfiguration = configuration;
        } else {
            this.configurationsMap.put(key, configuration);
        }
    }

    public String getConfigurationKeyOfCaller(String callerID) {
        if (callerID != null) {
            if (this.configurationsMap.containsKey(callerID = callerID.trim())) {
                return callerID;
            }
            int index = callerID.indexOf(".");
            if (index > 0) {
                String rootDomain = callerID.substring(index + 1, callerID.length());
                if (rootDomain != null) {
                    String all = "*." + rootDomain;
                    Set keyset = this.configurationsMap.keySet();
                    if (keyset != null && !keyset.isEmpty()) {
                        Iterator iter = keyset.iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            if (key == null || !key.endsWith(all)) continue;
                            return key;
                        }
                    }
                    return this.getConfigurationKeyOfCaller(rootDomain);
                }
            } else {
                String all = "*." + callerID;
                Set keyset = this.configurationsMap.keySet();
                if (keyset != null && !keyset.isEmpty()) {
                    Iterator iter = keyset.iterator();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        if (key == null || !key.endsWith(all)) continue;
                        return key;
                    }
                }
            }
        }
        return this.keyOfOther;
    }

    public int getType() {
        return 1;
    }
}

