/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ConfigurationFactory;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MessageProcessorFactory;
import org.apache.synapse.config.xml.MessageStoreFactory;
import org.apache.synapse.config.xml.ProxyServiceFactory;
import org.apache.synapse.config.xml.RegistryFactory;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.SynapseImportFactory;
import org.apache.synapse.config.xml.SynapseXMLConfigurationSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.config.xml.eventing.EventSourceFactory;
import org.apache.synapse.config.xml.rest.APIFactory;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.rest.API;

public class SynapseXMLConfigurationFactory
implements ConfigurationFactory {
    private static Log log = LogFactory.getLog(SynapseXMLConfigurationFactory.class);

    @Override
    public SynapseConfiguration getConfiguration(OMElement definitions, Properties properties) {
        if (!definitions.getQName().equals(XMLConfigConstants.DEFINITIONS_ELT)) {
            throw new SynapseException("Wrong QName for this configuration factory " + definitions.getQName());
        }
        SynapseConfiguration config = SynapseConfigUtils.newConfiguration();
        config.setDefaultQName(definitions.getQName());
        Iterator itr = definitions.getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof OMElement)) continue;
            OMElement elt = (OMElement)o;
            if (XMLConfigConstants.SEQUENCE_ELT.equals(elt.getQName())) {
                String key = elt.getAttributeValue(new QName("", "key"));
                if (key != null) {
                    SynapseXMLConfigurationFactory.handleException("Referred sequences are not allowed at the top level");
                    continue;
                }
                SynapseXMLConfigurationFactory.defineSequence(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.TEMPLATE_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineTemplate(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.IMPORT_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineImport(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.ENDPOINT_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEndpoint(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.ENTRY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEntry(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.PROXY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineProxy(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.REGISTRY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineRegistry(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.EVENT_SOURCE_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEventSource(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.EXECUTOR_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineExecutor(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.MESSAGE_STORE_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineMessageStore(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.MESSAGE_PROCESSOR_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineMessageProcessor(config, elt, properties);
                continue;
            }
            if (StartupFinder.getInstance().isStartup(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineStartup(config, elt, properties);
                continue;
            }
            if (XMLConfigConstants.API_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineAPI(config, elt);
                continue;
            }
            if (XMLConfigConstants.DESCRIPTION_ELT.equals(elt.getQName())) {
                config.setDescription(elt.getText());
                continue;
            }
            SynapseXMLConfigurationFactory.handleException("Invalid configuration element at the top level, one of 'sequence', 'endpoint', 'proxy', 'eventSource', 'localEntry', 'priorityExecutor' or 'registry' is expected. Found '" + elt.getQName() + "'.");
        }
        return config;
    }

    public static Registry defineRegistry(SynapseConfiguration config, OMElement elem, Properties properties) {
        if (config.getRegistry() != null) {
            SynapseXMLConfigurationFactory.handleException("Only one remote registry can be defined within a configuration");
        }
        Registry registry = RegistryFactory.createRegistry(elem, properties);
        config.setRegistry(registry);
        return registry;
    }

    public static Startup defineStartup(SynapseConfiguration config, OMElement elem, Properties properties) {
        Startup startup = StartupFinder.getInstance().getStartup(elem, properties);
        config.addStartup(startup);
        return startup;
    }

    public static ProxyService defineProxy(SynapseConfiguration config, OMElement elem, Properties properties) {
        ProxyService proxy = null;
        try {
            proxy = ProxyServiceFactory.createProxy(elem, properties);
            if (proxy != null) {
                config.addProxyService(proxy.getName(), proxy);
            }
        }
        catch (Exception e) {
            String msg = "Proxy Service configuration: " + elem.getAttributeValue(new QName("", "name")) + " cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("proxyservices", msg, e);
        }
        return proxy;
    }

    public static Entry defineEntry(SynapseConfiguration config, OMElement elem, Properties properties) {
        Entry entry = null;
        try {
            entry = EntryFactory.createEntry(elem, properties);
            if (entry != null) {
                config.addEntry(entry.getKey(), entry);
            }
        }
        catch (Exception e) {
            String msg = "Local entry configuration: " + elem.getAttributeValue(new QName("", "key")) + " cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("localentries", msg, e);
        }
        return entry;
    }

    public static Mediator defineSequence(SynapseConfiguration config, OMElement ele, Properties properties) {
        Mediator mediator = null;
        String name = ele.getAttributeValue(new QName("", "name"));
        if (name != null) {
            try {
                mediator = MediatorFactoryFinder.getInstance().getMediator(ele, properties);
                if (mediator != null) {
                    config.addSequence(name, mediator);
                    if ("pre-mediate".equals(name)) {
                        config.setMandatorySequence(mediator);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Sequence configuration: " + name + " cannot be built";
                SynapseXMLConfigurationFactory.handleConfigurationError("sequences", msg, e);
            }
            return mediator;
        }
        String msg = "Invalid sequence definition without a name";
        SynapseXMLConfigurationFactory.handleConfigurationError("sequences", msg);
        return null;
    }

    public static Mediator defineMediatorTemplate(SynapseConfiguration config, OMElement ele, Properties properties) {
        Mediator mediator = null;
        String name = ele.getAttributeValue(new QName("", "name"));
        if (name != null) {
            try {
                mediator = MediatorFactoryFinder.getInstance().getMediator(ele, properties);
                if (mediator != null) {
                    config.addSequenceTemplate(name, (TemplateMediator)mediator);
                }
            }
            catch (Exception e) {
                String msg = "Template configuration: " + name + " cannot be built";
                SynapseXMLConfigurationFactory.handleConfigurationError("templates", msg, e);
            }
            return mediator;
        }
        String msg = "Invalid mediation template definition without a name";
        SynapseXMLConfigurationFactory.handleConfigurationError("templates", msg);
        return null;
    }

    public static Endpoint defineEndpoint(SynapseConfiguration config, OMElement ele, Properties properties) {
        String name = ele.getAttributeValue(new QName("", "name"));
        Endpoint endpoint = null;
        if (name != null) {
            try {
                endpoint = EndpointFactory.getEndpointFromElement(ele, false, properties);
                if (endpoint != null) {
                    config.addEndpoint(name.trim(), endpoint);
                }
            }
            catch (Exception e) {
                String msg = "Endpoint configuration: " + name + " cannot be built";
                SynapseXMLConfigurationFactory.handleConfigurationError("endpoints", msg, e);
            }
            return endpoint;
        }
        String msg = "Invalid endpoint definition without a name";
        SynapseXMLConfigurationFactory.handleConfigurationError("endpoints", msg);
        return null;
    }

    public static SynapseEventSource defineEventSource(SynapseConfiguration config, OMElement elem, Properties properties) {
        SynapseEventSource eventSource = null;
        try {
            eventSource = EventSourceFactory.createEventSource(elem, properties);
            if (eventSource != null) {
                config.addEventSource(eventSource.getName(), eventSource);
            }
        }
        catch (Exception e) {
            String msg = "Event Source configuration cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("eventsources", msg, e);
        }
        return eventSource;
    }

    public static PriorityExecutor defineExecutor(SynapseConfiguration config, OMElement elem, Properties properties) {
        PriorityExecutor executor = null;
        try {
            executor = PriorityExecutorFactory.createExecutor((String)"http://ws.apache.org/ns/synapse", (OMElement)elem, (boolean)true, (Properties)properties);
            assert (executor != null);
            config.addPriorityExecutor(executor.getName(), executor);
        }
        catch (AxisFault axisFault) {
            String msg = "Executor configuration cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("executors", msg, (Exception)((Object)axisFault));
        }
        return executor;
    }

    public static MessageStore defineMessageStore(SynapseConfiguration config, OMElement elem, Properties properties) {
        MessageStore messageStore = null;
        try {
            messageStore = MessageStoreFactory.createMessageStore(elem, properties);
            config.addMessageStore(messageStore.getName(), messageStore);
        }
        catch (Exception e) {
            String msg = "Message Store configuration cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("messagestores", msg, e);
        }
        return messageStore;
    }

    public static MessageProcessor defineMessageProcessor(SynapseConfiguration config, OMElement elem, Properties properties) {
        MessageProcessor processor = null;
        try {
            processor = MessageProcessorFactory.createMessageProcessor(elem);
            config.addMessageProcessor(processor.getName(), processor);
        }
        catch (Exception e) {
            String msg = "Message Processor configuration cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("messageprocessors", msg, e);
        }
        return processor;
    }

    public static SynapseImport defineImport(SynapseConfiguration config, OMElement elt, Properties properties) {
        SynapseImport synImport = SynapseImportFactory.createImport(elt, properties);
        String libIndexString = LibDeployerUtils.getQualifiedName(synImport);
        config.addSynapseImport(libIndexString, synImport);
        Library synLib = config.getSynapseLibraries().get(libIndexString);
        if (synLib != null) {
            LibDeployerUtils.loadLibArtifacts(synImport, synLib);
        }
        return synImport;
    }

    public static Template defineEndpointTemplate(SynapseConfiguration config, OMElement elem, Properties properties) {
        TemplateFactory templateFactory = new TemplateFactory();
        String name = elem.getAttributeValue(new QName("", "name"));
        try {
            Template template = templateFactory.createEndpointTemplate(elem, properties);
            if (template != null) {
                config.addEndpointTemplate(template.getName(), template);
            }
            return template;
        }
        catch (Exception e) {
            String msg = "Endpoint Template: " + name + "configuration cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("templates", msg, e);
            return null;
        }
    }

    public static void defineTemplate(SynapseConfiguration config, OMElement elem, Properties properties) {
        OMElement element = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
        if (element != null) {
            SynapseXMLConfigurationFactory.defineMediatorTemplate(config, elem, properties);
        }
        if ((element = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"))) != null) {
            SynapseXMLConfigurationFactory.defineEndpointTemplate(config, elem, properties);
        }
    }

    public static API defineAPI(SynapseConfiguration config, OMElement elem) {
        API api = null;
        try {
            api = APIFactory.createAPI(elem);
            config.addAPI(api.getName(), api);
        }
        catch (Exception e) {
            String msg = "API configuration cannot be built";
            SynapseXMLConfigurationFactory.handleConfigurationError("apis", msg, e);
        }
        return api;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    @Override
    public QName getTagQName() {
        return XMLConfigConstants.DEFINITIONS_ELT;
    }

    @Override
    public Class getSerializerClass() {
        return SynapseXMLConfigurationSerializer.class;
    }

    private static void handleConfigurationError(String componentType, String msg) {
        if (SynapseConfigUtils.isFailSafeEnabled(componentType)) {
            log.warn((Object)(msg + " - Continue in fail-safe mode"));
        } else {
            SynapseXMLConfigurationFactory.handleException(msg);
        }
    }

    private static void handleConfigurationError(String componentType, String msg, Exception e) {
        if (!SynapseConfigUtils.isFailSafeEnabled(componentType)) {
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
        log.warn((Object)(msg + " - Continue in fail-safe mode"), (Throwable)e);
    }
}

